/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.impl;

import com.sun.java.help.impl.DocumentParser;
import com.sun.java.help.impl.ParserEvent;
import com.sun.java.help.impl.ParserListener;
import com.sun.java.help.impl.Tag;
import com.sun.java.help.impl.TagProperties;
import java.io.InputStream;
import java.io.Reader;
import java.util.EventListener;

public class Parser
extends DocumentParser {
    protected ParserListener listenerList;

    public Parser(Reader src) {
        super(src);
    }

    public Parser(InputStream in) {
        super(in);
    }

    @Override
    protected void tag(String name, TagProperties atts, boolean endTag, boolean emptyTag) {
        Tag tag = new Tag(name, atts, endTag, emptyTag);
        this.listenerList.tagFound(new ParserEvent((Object)this, tag));
    }

    @Override
    protected void pi(String target, String data) {
        this.listenerList.piFound(new ParserEvent(this, target, data));
    }

    @Override
    protected void doctype(String root, String publicId, String systemId) {
        this.listenerList.doctypeFound(new ParserEvent(this, root, publicId, systemId));
    }

    @Override
    protected void flush(char[] buf, int offset, int length) {
        if (length == 1 && (buf[offset] == '\n' || buf[offset] == '\r')) {
            return;
        }
        String text = new String(buf, offset, length);
        this.listenerList.textFound(new ParserEvent((Object)this, text));
    }

    @Override
    protected void comment(String s) {
        this.listenerList.commentFound(new ParserEvent((Object)this, s));
    }

    @Override
    protected void errorString(String s) {
        this.listenerList.errorFound(new ParserEvent((Object)this, s));
    }

    @Override
    protected String documentAttribute(String name) {
        return null;
    }

    public void addParserListener(ParserListener l) {
        this.listenerList = ParserMulticaster.add(this.listenerList, l);
    }

    public void removeParserListener(ParserListener l) {
        this.listenerList = ParserMulticaster.remove(this.listenerList, l);
    }

    protected static class ParserMulticaster
    implements ParserListener {
        protected final EventListener a;
        protected final EventListener b;

        protected ParserMulticaster(EventListener newA, EventListener newB) {
            this.a = newA;
            this.b = newB;
        }

        protected EventListener remove(EventListener oldl) {
            if (oldl == this.a) {
                return this.b;
            }
            if (oldl == this.b) {
                return this.a;
            }
            EventListener a2 = ParserMulticaster.removeInternal(this.a, oldl);
            EventListener b2 = ParserMulticaster.removeInternal(this.b, oldl);
            if (a2 == this.a && b2 == this.b) {
                return this;
            }
            return ParserMulticaster.addInternal(a2, b2);
        }

        protected static EventListener addInternal(EventListener a, EventListener b) {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            return new ParserMulticaster(a, b);
        }

        protected static EventListener removeInternal(EventListener l, EventListener oldl) {
            if (l == oldl || l == null) {
                return null;
            }
            if (l instanceof ParserMulticaster) {
                return ((ParserMulticaster)l).remove(oldl);
            }
            return l;
        }

        @Override
        public void tagFound(ParserEvent e) {
            ((ParserListener)this.a).tagFound(e);
            ((ParserListener)this.b).tagFound(e);
        }

        @Override
        public void piFound(ParserEvent e) {
            ((ParserListener)this.a).piFound(e);
            ((ParserListener)this.b).piFound(e);
        }

        @Override
        public void doctypeFound(ParserEvent e) {
            ((ParserListener)this.a).doctypeFound(e);
            ((ParserListener)this.b).doctypeFound(e);
        }

        @Override
        public void textFound(ParserEvent e) {
            ((ParserListener)this.a).textFound(e);
            ((ParserListener)this.b).textFound(e);
        }

        @Override
        public void commentFound(ParserEvent e) {
            ((ParserListener)this.a).commentFound(e);
            ((ParserListener)this.b).commentFound(e);
        }

        @Override
        public void errorFound(ParserEvent e) {
            ((ParserListener)this.a).errorFound(e);
            ((ParserListener)this.b).errorFound(e);
        }

        public static ParserListener add(ParserListener a, ParserListener b) {
            return (ParserListener)ParserMulticaster.addInternal(a, b);
        }

        public static ParserListener remove(ParserListener l, ParserListener oldl) {
            return (ParserListener)ParserMulticaster.removeInternal(l, oldl);
        }
    }
}

