/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.impl;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class TagProperties
implements Cloneable {
    protected Hashtable hashtable;
    protected int initialSize;
    static int count1 = 0;
    static int count2 = 0;

    public TagProperties() {
        this(7);
    }

    public TagProperties(int initialSize) {
        this.initialSize = initialSize;
    }

    public String getProperty(String key) {
        return (String)this.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        String val = this.getProperty(key);
        return val == null ? defaultValue : val;
    }

    public Enumeration propertyNames() {
        Hashtable h = new Hashtable(11);
        this.enumerate(h);
        return h.keys();
    }

    public void list(PrintStream out) {
        out.println("-- listing properties --");
        Hashtable h = new Hashtable(11);
        this.enumerate(h);
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object val = (String)h.get(key);
            if (((String)val).length() > 40) {
                val = ((String)val).substring(0, 37) + "...";
            }
            out.println(key + "=" + (String)val);
        }
    }

    public void list(PrintWriter out) {
        out.println("-- listing properties --");
        Hashtable h = new Hashtable(11);
        this.enumerate(h);
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object val = (String)h.get(key);
            if (((String)val).length() > 40) {
                val = ((String)val).substring(0, 37) + "...";
            }
            out.println(key + "=" + (String)val);
        }
    }

    private synchronized void enumerate(Hashtable h) {
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            h.put(key, this.get(key));
        }
    }

    public int size() {
        if (this.hashtable != null) {
            return this.hashtable.size();
        }
        return 0;
    }

    public boolean isEmpty() {
        if (this.hashtable != null) {
            return this.hashtable.isEmpty();
        }
        return true;
    }

    public synchronized Enumeration keys() {
        if (this.hashtable != null) {
            return this.hashtable.keys();
        }
        return new EmptyEnumerator();
    }

    public synchronized Enumeration elements() {
        if (this.hashtable != null) {
            return this.hashtable.elements();
        }
        return new EmptyEnumerator();
    }

    public synchronized boolean contains(Object value) {
        if (this.hashtable != null) {
            return this.hashtable.contains(value);
        }
        return false;
    }

    public synchronized boolean containsKey(Object key) {
        if (this.hashtable != null) {
            return this.hashtable.containsKey(key);
        }
        return false;
    }

    public synchronized Object get(Object key) {
        if (this.hashtable != null) {
            return this.hashtable.get(key);
        }
        return null;
    }

    public synchronized Object put(Object key, Object value) {
        if (this.hashtable == null) {
            this.hashtable = new Hashtable(this.initialSize);
        }
        return this.hashtable.put(key, value);
    }

    public synchronized Object remove(Object key) {
        if (this.hashtable != null) {
            return this.hashtable.remove(key);
        }
        return null;
    }

    public synchronized void clear() {
        if (this.hashtable != null) {
            this.hashtable.clear();
        }
    }

    protected void setHashtable(Hashtable t) {
        this.hashtable = t;
    }

    public Hashtable getHashtable() {
        return this.hashtable;
    }

    public synchronized Object clone() {
        try {
            TagProperties tp = (TagProperties)super.clone();
            if (this.hashtable != null) {
                tp.setHashtable((Hashtable)this.hashtable.clone());
            }
            return tp;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public synchronized String toString() {
        if (this.hashtable != null) {
            return this.hashtable.toString();
        }
        return "{ }";
    }

    class EmptyEnumerator
    implements Enumeration {
        EmptyEnumerator() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException("EmptyEnumerator");
        }
    }
}

