/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpNavigator;
import javax.help.Map;
import javax.help.TextHelpModel;
import javax.help.event.EventListenerList;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.event.TextHelpModelEvent;
import javax.help.event.TextHelpModelListener;

public class DefaultHelpModel
implements TextHelpModel,
Serializable {
    private HelpSet helpset;
    private Map.ID currentID;
    private URL currentURL;
    private String navID;
    private Vector highlights = new Vector();
    private String title;
    protected EventListenerList listenerList = new EventListenerList();
    protected EventListenerList textListenerList = new EventListenerList();
    protected PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private static boolean debug = false;

    public DefaultHelpModel(HelpSet hs) {
        this.helpset = hs;
    }

    @Override
    public void setHelpSet(HelpSet hs) {
        HelpSet old = this.helpset;
        this.helpset = hs;
        this.changes.firePropertyChange("helpSet", old, hs);
    }

    @Override
    public HelpSet getHelpSet() {
        return this.helpset;
    }

    @Override
    public void setCurrentID(Map.ID ident) throws InvalidHelpSetContextException {
        this.setCurrentID(ident, null, null);
    }

    @Override
    public void setCurrentID(Map.ID ident, String historyName, JHelpNavigator navigator) throws InvalidHelpSetContextException {
        if (ident == null) {
            ident = this.helpset.getHomeID();
        }
        if (ident == null || ident.equals(this.currentID)) {
            return;
        }
        String id = ident.id;
        HelpSet hs = ident.hs;
        if (!this.helpset.contains(hs)) {
            throw new InvalidHelpSetContextException("Wrong context", this.helpset, hs);
        }
        Map map = this.helpset.getCombinedMap();
        this.currentID = ident;
        try {
            URL url;
            Map.ID tmpID = ident;
            if (hs == this.helpset) {
                url = map.getURLFromID(ident);
            } else {
                Map hsmap = hs.getLocalMap();
                url = hsmap.getURLFromID(ident);
            }
            if (this.currentURL != null && this.currentURL.equals(url)) {
                String currentRef = this.currentURL.getRef();
                String urlRef = url.getRef();
                if (currentRef == null && urlRef == null) {
                    return;
                }
                if (currentRef != null && urlRef != null && currentRef.compareTo(urlRef) == 0) {
                    return;
                }
            }
            this.currentURL = url;
        }
        catch (Exception ex) {
            this.currentURL = null;
        }
        this.highlights.setSize(0);
        this.fireIDChanged(this, this.currentID, this.currentURL, historyName, navigator);
    }

    @Override
    public Map.ID getCurrentID() {
        return this.currentID;
    }

    @Override
    public void setCurrentURL(URL url) {
        this.setCurrentURL(url, null, null);
    }

    @Override
    public void setCurrentURL(URL url, String historyName, JHelpNavigator navigator) {
        boolean fire = false;
        if (this.currentURL == null) {
            if (this.currentURL != url) {
                this.currentURL = url;
                fire = true;
            }
        } else if (!this.currentURL.equals(url)) {
            this.currentURL = url;
            fire = true;
        }
        if (this.currentURL == null) {
            if (this.currentID != null) {
                this.currentID = null;
                fire = true;
            }
        } else {
            Map.ID id = this.helpset.getCombinedMap().getIDFromURL(this.currentURL);
            if (this.currentID == null) {
                if (this.currentID != id) {
                    this.currentID = id;
                    fire = true;
                }
            } else if (!this.currentID.equals(id)) {
                this.currentID = id;
                fire = true;
            }
        }
        if (fire) {
            this.highlights.setSize(0);
            this.fireIDChanged(this, this.currentID, this.currentURL, historyName, navigator);
        }
    }

    @Override
    public URL getCurrentURL() {
        return this.currentURL;
    }

    @Override
    public void addHighlight(int pos0, int pos1) {
        DefaultHelpModel.debug("addHighlight(" + pos0 + ", " + pos1 + ")");
        this.highlights.addElement(new DefaultHighlight(pos0, pos1));
        this.fireHighlightsChanged(this);
    }

    @Override
    public void removeAllHighlights() {
        DefaultHelpModel.debug("removeAllHighlights");
        this.highlights.setSize(0);
        this.fireHighlightsChanged(this);
    }

    @Override
    public void setHighlights(TextHelpModel.Highlight[] h) {
        this.highlights.setSize(0);
        if (h == null) {
            return;
        }
        for (int i = 0; i < h.length; ++i) {
            this.highlights.addElement(new DefaultHighlight(h[i].getStartOffset(), h[i].getEndOffset()));
        }
        if (this.highlights.size() > 0) {
            this.fireHighlightsChanged(this);
        }
    }

    @Override
    public TextHelpModel.Highlight[] getHighlights() {
        Object[] back = new DefaultHighlight[this.highlights.size()];
        this.highlights.copyInto(back);
        return back;
    }

    @Override
    public void addHelpModelListener(HelpModelListener l) {
        DefaultHelpModel.debug("addHelpModelListener: ");
        DefaultHelpModel.debug("  l:" + l);
        if (debug) {
            try {
                throw new Exception("");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.listenerList.add(HelpModelListener.class, l);
    }

    @Override
    public void removeHelpModelListener(HelpModelListener l) {
        this.listenerList.remove(HelpModelListener.class, l);
    }

    @Override
    public void addTextHelpModelListener(TextHelpModelListener l) {
        DefaultHelpModel.debug("addTextHelpModelListener: ");
        DefaultHelpModel.debug("  l:" + l);
        if (debug) {
            try {
                throw new Exception("");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.textListenerList.add(TextHelpModelListener.class, l);
    }

    @Override
    public void removeTextHelpModelListener(TextHelpModelListener l) {
        this.textListenerList.remove(TextHelpModelListener.class, l);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }

    @Override
    public void setDocumentTitle(String title) {
        String oldTitle = this.title;
        this.title = title;
        this.changes.firePropertyChange("documentTitle", oldTitle, title);
    }

    @Override
    public String getDocumentTitle() {
        return this.title;
    }

    protected void fireIDChanged(Object source, Map.ID id, URL url, String historyName, JHelpNavigator navigator) {
        Object[] listeners = this.listenerList.getListenerList();
        HelpModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != HelpModelListener.class) continue;
            if (e == null) {
                e = new HelpModelEvent(source, id, url, historyName, navigator);
            }
            DefaultHelpModel.debug("fireIDChanged: ");
            DefaultHelpModel.debug("  " + listeners[i + 1]);
            DefaultHelpModel.debug("  id=" + e.getID() + " url=" + e.getURL());
            ((HelpModelListener)listeners[i + 1]).idChanged(e);
        }
    }

    protected void fireIDChanged(Object source, Map.ID id, URL url) {
        this.fireIDChanged(source, id, url, null, null);
    }

    protected void fireHighlightsChanged(Object source) {
        Object[] listeners = this.textListenerList.getListenerList();
        TextHelpModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TextHelpModelListener.class) continue;
            if (e == null) {
                e = new TextHelpModelEvent(source);
            }
            DefaultHelpModel.debug("fireHighlightsChanged: ");
            DefaultHelpModel.debug("  " + listeners[i + 1]);
            DefaultHelpModel.debug("  " + e);
            ((TextHelpModelListener)listeners[i + 1]).highlightsChanged(e);
        }
    }

    private static void debug(String str) {
        if (debug) {
            System.err.println("DefaultHelpModel: " + str);
        }
    }

    public static class DefaultHighlight
    implements TextHelpModel.Highlight {
        public int start;
        public int end;

        public DefaultHighlight(int start, int end) {
            if (start < 0) {
                throw new IllegalArgumentException("start");
            }
            if (end < 0) {
                throw new IllegalArgumentException("end");
            }
            this.start = start;
            this.end = end;
        }

        @Override
        public int getStartOffset() {
            return this.start;
        }

        @Override
        public int getEndOffset() {
            return this.end;
        }
    }
}

