/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Vector;
import javax.help.TreeItem;

public class FavoritesItem
extends TreeItem
implements Transferable,
Serializable {
    private boolean isFolder = false;
    public static final DataFlavor FAVORITES_FLAVOR = new DataFlavor(FavoritesItem.class, "Favorites Item");
    static DataFlavor[] flavors = new DataFlavor[]{FAVORITES_FLAVOR};
    private FavoritesItem parent = null;
    private Vector children = new Vector();
    private String url = null;
    private String target = null;
    private String title = null;
    private boolean emptyInitState = true;
    private boolean visible = true;

    public FavoritesItem(String name) {
        this.setName(name);
    }

    public FavoritesItem() {
        this(null);
    }

    public FavoritesItem(String name, String target, String url, String title, Locale locale) {
        this(name);
        this.target = target;
        this.url = url;
        this.locale = locale;
        this.title = title;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String getTarget() {
        return this.target;
    }

    public String getURLSpec() {
        return this.url;
    }

    @Override
    public URL getURL() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public String getHelpSetTitle() {
        return this.title;
    }

    public void setAsFolder() {
        this.isFolder = true;
    }

    public boolean allowsChildren() {
        return this.isFolder();
    }

    public boolean isLeaf() {
        return !this.isFolder();
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public void add(FavoritesItem item) {
        item.setParent(this);
        this.children.add(item);
        this.emptyInitState = false;
        this.isFolder = true;
    }

    public boolean emptyInitState() {
        return this.emptyInitState;
    }

    public void remove(FavoritesItem item) {
        item.setParent(null);
        this.children.remove(item);
    }

    public FavoritesItem getParent() {
        return this.parent;
    }

    public void setParent(FavoritesItem parent) {
        this.parent = parent;
    }

    public Vector getChildren() {
        return this.children;
    }

    public Object clone() {
        FavoritesItem item = new FavoritesItem(this.getName(), this.target, this.url, this.title, this.locale);
        return item;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
        if (df.equals(FAVORITES_FLAVOR)) {
            return this;
        }
        throw new UnsupportedFlavorException(df);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor df) {
        return df.equals(FAVORITES_FLAVOR);
    }
}

