/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import javax.help.FavoritesItem;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class FavoritesNode
extends DefaultMutableTreeNode {
    public static final String HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE favorites\n PUBLIC \"-//Sun Microsystems Inc.//DTD JavaHelp Favorites Version 2.0//EN\"\n        \"http://java.sun.com/products/javahelp/favorites_2_0.dtd\">\n\n<favorites version=\"2.0\">\n";
    public static final String ELEMENT = "favoriteitem";
    public static final String FOOTER = "</favorites>";
    private FavoritesItem item;
    private static final boolean debug = false;

    public FavoritesNode(FavoritesItem item) {
        super(item);
        this.item = item;
    }

    @Override
    public boolean getAllowsChildren() {
        return ((FavoritesItem)this.getUserObject()).isFolder();
    }

    public void add(DefaultMutableTreeNode child) {
        super.add(child);
        FavoritesItem childItem = (FavoritesItem)child.getUserObject();
        FavoritesItem oldParent = childItem.getParent();
        FavoritesItem newParent = (FavoritesItem)this.getUserObject();
        newParent.add(childItem);
    }

    public void remove(DefaultMutableTreeNode child) {
        super.remove(child);
        FavoritesItem childItem = (FavoritesItem)((FavoritesNode)child).getUserObject();
        FavoritesItem ParentItem = (FavoritesItem)this.getUserObject();
        if (this.parent != null) {
            ParentItem.remove(childItem);
        }
    }

    public int getVisibleChildCount() {
        int count = 0;
        if (this.item == null) {
            return 0;
        }
        Enumeration en = this.item.getChildren().elements();
        while (en.hasMoreElements()) {
            FavoritesItem nItem = (FavoritesItem)en.nextElement();
            if (!nItem.isVisible()) continue;
            ++count;
        }
        return count;
    }

    public String getOffset() {
        String parentOffset = null;
        Object offset = null;
        FavoritesNode parent = (FavoritesNode)this.getParent();
        if (parent != null) {
            parentOffset = parent.getOffset();
            offset = parentOffset + "  ";
        } else {
            offset = "  ";
        }
        return offset;
    }

    public void export(OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        writer = this.exportHeader(out);
        Enumeration<TreeNode> chldn = this.children();
        if (!chldn.equals(DefaultMutableTreeNode.EMPTY_ENUMERATION)) {
            while (chldn.hasMoreElements()) {
                FavoritesNode node = (FavoritesNode)chldn.nextElement();
                node.exportNode(writer);
            }
        }
        writer.write(FOOTER);
        writer.close();
    }

    public void exportNode(OutputStreamWriter writer) throws IOException {
        Enumeration<TreeNode> chldn;
        String hstitle;
        String url;
        TreeNode paren = this.getParent();
        FavoritesItem item = (FavoritesItem)this.getUserObject();
        writer.write(this.getOffset() + "<" + this.getXMLElement() + " text=\"" + item.getName() + "\" ");
        String target = item.getTarget();
        if (target != null) {
            writer.write("target=\"" + target + "\" ");
        }
        if ((url = item.getURLSpec()) != null) {
            writer.write("url=\"" + url + "\"");
        }
        if ((hstitle = item.getHelpSetTitle()) != null) {
            writer.write(" hstitle=\"" + hstitle + "\"");
        }
        if ((chldn = this.children()).equals(DefaultMutableTreeNode.EMPTY_ENUMERATION)) {
            writer.write("/>\n");
        } else {
            writer.write(">\n");
            Enumeration offspring = this.children.elements();
            while (offspring.hasMoreElements()) {
                FavoritesNode off = (FavoritesNode)offspring.nextElement();
                FavoritesNode.debug("offspring: " + off);
                off.exportNode(writer);
            }
            writer.write(this.getOffset() + "</favoriteitem>\n");
        }
    }

    public OutputStreamWriter exportHeader(OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
        writer.write(HEADER);
        return writer;
    }

    public String getXMLHeader() {
        return HEADER;
    }

    public String getXMLElement() {
        return ELEMENT;
    }

    public FavoritesNode getDeepCopy() {
        return new FavoritesNode((FavoritesItem)this.item.clone());
    }

    public boolean isVisible() {
        return this.item.isVisible();
    }

    public void setVisible(boolean vis) {
        this.item.setVisible(vis);
    }

    private static void debug(String msg) {
    }
}

