/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import com.sun.java.help.impl.Parser;
import com.sun.java.help.impl.ParserEvent;
import com.sun.java.help.impl.ParserListener;
import com.sun.java.help.impl.Tag;
import com.sun.java.help.impl.TagProperties;
import com.sun.java.help.impl.XmlReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.Map;

public class FlatMap
implements Map,
Serializable {
    private URL base;
    private ResourceBundle resource;
    private HelpSet helpset;
    public static final String publicIDString = "-//Sun Microsystems Inc.//DTD JavaHelp Map Version 1.0//EN";
    public static final String publicIDString_V2 = "-//Sun Microsystems Inc.//DTD JavaHelp Map Version 2.0//EN";
    private static final boolean debug = false;

    public FlatMap(URL base, HelpSet hs) throws IOException {
        FlatMap.debug("Creating FlatMap for: " + base);
        Enumeration e = hs.getHelpSets();
        if (e.hasMoreElements()) {
            throw new IllegalArgumentException("Cannot create - HelpSet is not flat");
        }
        this.resource = new FlatMapResourceBundle(base);
        this.base = base;
        this.helpset = hs;
    }

    public HelpSet getHelpSet() {
        return this.helpset;
    }

    @Override
    public boolean isValidID(String id, HelpSet hs) {
        FlatMap.debug("isValidID " + id);
        try {
            String string = this.resource.getString(id);
        }
        catch (MissingResourceException e) {
            return false;
        }
        return true;
    }

    @Override
    public Enumeration getAllIDs() {
        return new FlatEnumeration(this.resource.getKeys(), this.helpset);
    }

    @Override
    public URL getURLFromID(Map.ID iden) throws MalformedURLException {
        FlatMap.debug("getURLFromID(" + iden + ")");
        String id = iden.id;
        HelpSet hs = iden.hs;
        if (id == null) {
            return null;
        }
        String tmp = null;
        try {
            tmp = this.resource.getString(id);
            URL back = new URL(this.base, tmp);
            return back;
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    @Override
    public boolean isID(URL url) {
        Enumeration<String> e = this.resource.getKeys();
        while (e.hasMoreElements()) {
            try {
                String key = e.nextElement();
                URL tmp = new URL(this.base, (String)this.resource.getObject(key));
                if (!url.sameFile(tmp)) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    @Override
    public Map.ID getIDFromURL(URL url) {
        if (url == null) {
            return null;
        }
        String urlString = url.toExternalForm();
        Enumeration<String> e = this.resource.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            try {
                String tmpString;
                String tmp = this.resource.getString(key);
                URL tmpURL = new URL(this.base, tmp);
                if (tmpURL == null || urlString.compareTo(tmpString = tmpURL.toExternalForm()) != 0) continue;
                return Map.ID.create(key, this.helpset);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    @Override
    public Map.ID getClosestID(URL url) {
        return this.getIDFromURL(url);
    }

    @Override
    public Enumeration getIDs(URL url) {
        String tmp = null;
        URL tmpURL = null;
        Vector<String> ids = new Vector<String>();
        Enumeration<String> e = this.resource.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            try {
                tmp = this.resource.getString(key);
                tmpURL = new URL(this.base, tmp);
                if (!url.sameFile(tmpURL)) continue;
                ids.addElement(key);
            }
            catch (Exception exception) {}
        }
        return new FlatEnumeration(ids.elements(), this.helpset);
    }

    private static void debug(String str) {
    }

    protected class FlatMapResourceBundle
    extends ResourceBundle
    implements ParserListener,
    Serializable {
        private Hashtable lookup = null;
        private boolean startedmap;
        private URL source;
        private Vector messages = new Vector();
        private boolean validParse = true;

        public FlatMapResourceBundle(URL url) {
            this.source = url;
            try {
                URLConnection uc = url.openConnection();
                Reader src = XmlReader.createReader(uc);
                this.parse(src);
                src.close();
            }
            catch (Exception e) {
                this.reportMessage("Exception caught while parsing " + url + " " + e.toString(), false);
            }
            this.parsingEnded();
            Enumeration e = this.lookup.keys();
            while (e.hasMoreElements()) {
                String key1 = (String)e.nextElement();
                String string = (String)this.lookup.get(key1);
            }
        }

        @Override
        public final Object handleGetObject(String key) {
            return this.lookup.get(key);
        }

        public Enumeration getKeys() {
            return this.lookup.keys();
        }

        synchronized void parse(Reader src) throws IOException {
            this.lookup = new Hashtable(10);
            Parser parser = new Parser(src);
            parser.addParserListener(this);
            parser.parse();
        }

        @Override
        public void tagFound(ParserEvent e) {
            Object locale = null;
            Tag tag = e.getTag();
            FlatMap.debug("TagFound: " + tag.name);
            TagProperties attr = tag.atts;
            if (tag.name.equals("mapID")) {
                if (!this.startedmap) {
                    this.parsingError("map.invalidMapFormat");
                }
                String target = null;
                String url = null;
                if (attr != null) {
                    target = attr.getProperty("target");
                    url = attr.getProperty("url");
                }
                if (target == null || url == null) {
                    this.reportMessage("Failure in mapID Creation;", true);
                    this.reportMessage("  target: " + target, true);
                    this.reportMessage("  url: " + url, true);
                    return;
                }
                this.lookup.put(target, url);
                return;
            }
            if (tag.name.equals("map")) {
                if (!tag.isEnd) {
                    String version;
                    if (attr != null && (version = attr.getProperty("version")) != null && version.compareTo("1.0") != 0 && version.compareTo("2.0") != 0) {
                        this.parsingError("map.unknownVersion", version);
                    }
                    if (this.startedmap) {
                        this.parsingError("map.invalidMapFormat");
                    }
                    this.startedmap = true;
                } else if (this.startedmap) {
                    this.startedmap = false;
                }
                return;
            }
        }

        @Override
        public void piFound(ParserEvent e) {
        }

        @Override
        public void doctypeFound(ParserEvent e) {
            String publicID = e.getPublicId();
            if (publicID == null || publicID.compareTo(FlatMap.publicIDString) != 0 && publicID.compareTo(FlatMap.publicIDString_V2) != 0) {
                this.parsingError("map.wrongPublicID", publicID);
            }
        }

        @Override
        public void textFound(ParserEvent e) {
        }

        @Override
        public void commentFound(ParserEvent e) {
        }

        @Override
        public void errorFound(ParserEvent e) {
            this.reportMessage(e.getText(), false);
        }

        public void reportMessage(String msg, boolean validParse) {
            this.messages.addElement(msg);
            this.validParse = this.validParse && validParse;
        }

        public Enumeration listMessages() {
            return this.messages.elements();
        }

        private void parsingEnded() {
            if (!this.validParse) {
                if (this.lookup != null) {
                    this.lookup.clear();
                }
                FlatMap.debug("Parsing failed for " + this.source);
                Enumeration e = this.messages.elements();
                while (e.hasMoreElements()) {
                    String msg = (String)e.nextElement();
                    FlatMap.debug(msg);
                }
            } else {
                this.source = null;
            }
        }

        private void parsingError(String key) {
            String s = HelpUtilities.getText(key);
            this.reportMessage(s, false);
        }

        private void parsingError(String key, String s) {
            String msg = HelpUtilities.getText(key, s);
            this.reportMessage(msg, false);
        }
    }

    private static class FlatEnumeration
    implements Enumeration {
        private Enumeration e;
        private HelpSet hs;

        public FlatEnumeration(Enumeration e, HelpSet hs) {
            this.e = e;
            this.hs = hs;
        }

        @Override
        public boolean hasMoreElements() {
            return this.e.hasMoreElements();
        }

        public Object nextElement() {
            Map.ID back = null;
            try {
                back = Map.ID.create((String)this.e.nextElement(), this.hs);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return back;
        }
    }
}

