/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Locale;
import javax.help.AbstractHelpAction;
import javax.help.HelpHistoryModel;
import javax.help.HelpUtilities;
import javax.help.JHelp;
import javax.help.event.HelpHistoryModelEvent;
import javax.help.event.HelpHistoryModelListener;
import javax.help.event.HelpModelEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import javax.swing.UIManager;

public class ForwardAction
extends AbstractHelpAction
implements MouseListener,
HelpHistoryModelListener {
    private static final String NAME = "ForwardAction";
    private static final int DELAY = 500;
    private Timer timer;
    private HelpHistoryModel historyModel;

    public ForwardAction(Object control) {
        super(control, NAME);
        if (control instanceof JHelp) {
            JHelp help = (JHelp)control;
            this.historyModel = help.getHistoryModel();
            this.historyModel.addHelpHistoryModelListener(this);
            this.setEnabled(this.historyModel.getIndex() > 0);
            this.putValue("icon", UIManager.getIcon("ForwardAction.icon"));
            Locale locale = null;
            try {
                locale = help.getModel().getHelpSet().getLocale();
            }
            catch (NullPointerException npe) {
                locale = Locale.getDefault();
            }
            this.putValue("tooltip", HelpUtilities.getString(locale, "tooltip.ForwardAction"));
            this.putValue("access", HelpUtilities.getString(locale, "access.ForwardAction"));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.timer = new Timer(500, new TimeListener(e));
        this.timer.start();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.historyModel != null && this.isEnabled()) {
            this.historyModel.goForward();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    private void showForwardHistory(MouseEvent e) {
        JPopupMenu forwardMenu = new JPopupMenu("Forward History");
        if (this.historyModel == null) {
            return;
        }
        Locale locale = ((JHelp)this.getControl()).getModel().getHelpSet().getLocale();
        Enumeration items = this.historyModel.getForwardHistory().elements();
        JMenuItem mi = null;
        int index = this.historyModel.getIndex() + 1;
        int i = 0;
        while (items.hasMoreElements()) {
            HelpModelEvent item = (HelpModelEvent)items.nextElement();
            if (item != null) {
                String title = item.getHistoryName();
                if (title == null) {
                    title = HelpUtilities.getString(locale, "history.unknownTitle");
                }
                mi = new JMenuItem(title);
                mi.addActionListener(new HistoryActionListener(i + index));
                forwardMenu.add(mi);
            }
            ++i;
        }
        forwardMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void historyChanged(HelpHistoryModelEvent e) {
        this.setEnabled(e.isNext());
    }

    private class TimeListener
    implements ActionListener {
        private MouseEvent e;

        public TimeListener(MouseEvent e) {
            this.e = e;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ForwardAction.this.timer.stop();
            if (ForwardAction.this.isEnabled()) {
                ForwardAction.this.showForwardHistory(this.e);
            }
        }
    }

    private class HistoryActionListener
    implements ActionListener {
        private int index;

        public HistoryActionListener(int index) {
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (ForwardAction.this.historyModel != null) {
                ForwardAction.this.historyModel.setHistoryEntry(this.index);
            }
        }
    }
}

