/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.io.InputStream;
import java.net.URL;
import java.text.CollationElementIterator;
import java.text.MessageFormat;
import java.text.RuleBasedCollator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class HelpUtilities {
    private static Hashtable tailsPerLocales = new Hashtable();
    private static Hashtable bundles;
    private static ResourceBundle lastBundle;
    private static Locale lastLocale;
    private static final boolean debug = false;

    public static String getHelpSetNameFromBean(Class beanClass) {
        Object helpSetName;
        try {
            BeanInfo bi = Introspector.getBeanInfo(beanClass);
            helpSetName = (String)bi.getBeanDescriptor().getValue("helpSetName");
        }
        catch (Exception ex) {
            helpSetName = null;
        }
        if (helpSetName == null) {
            String className = beanClass.getName();
            int index = className.lastIndexOf(".");
            if (index == -1) {
                helpSetName = className + "Help.hs";
            } else {
                String packageName = className.substring(0, index);
                helpSetName = packageName.replace('.', '/') + "/Help.hs";
            }
        }
        return helpSetName;
    }

    public static String getIDStringFromBean(Class beanClass) {
        Object helpID;
        try {
            BeanInfo bi = Introspector.getBeanInfo(beanClass);
            helpID = (String)bi.getBeanDescriptor().getValue("helpID");
        }
        catch (Exception ex) {
            helpID = null;
        }
        if (helpID == null) {
            String className = beanClass.getName();
            helpID = className + ".topID";
        }
        return helpID;
    }

    public static String getDefaultQueryEngine() {
        return "com.sun.java.help.search.DefaultSearchEngine";
    }

    public static URL getLocalizedResource(ClassLoader cl, String front, String back, Locale locale) {
        return HelpUtilities.getLocalizedResource(cl, front, back, locale, false);
    }

    public static URL getLocalizedResource(ClassLoader cl, String front, String back, Locale locale, boolean tryRead) {
        Enumeration tails = HelpUtilities.getCandidates(locale);
        while (tails.hasMoreElements()) {
            String tail = (String)tails.nextElement();
            String name = new StringBuffer(front).append(tail).append(back).toString();
            URL url = cl == null ? ClassLoader.getSystemResource(name) : cl.getResource(name);
            if (url == null) continue;
            if (tryRead) {
                try {
                    InputStream is = url.openConnection().getInputStream();
                    if (is == null) continue;
                    int i = is.read();
                    is.close();
                    if (i == -1) continue;
                    return url;
                }
                catch (Throwable throwable) {
                    continue;
                }
            }
            return url;
        }
        return null;
    }

    public static synchronized Enumeration getCandidates(Locale locale) {
        LocalePair pair = new LocalePair(locale, Locale.getDefault());
        Vector<String> tails = (Vector<String>)tailsPerLocales.get(pair);
        if (tails != null) {
            HelpUtilities.debug("getCandidates - cached copy");
            return tails.elements();
        }
        String lname1 = locale.toString();
        StringBuffer name1 = new StringBuffer("_").append(lname1);
        if (lname1 == null) {
            name1.setLength(0);
        }
        tails = new Vector<String>();
        while (name1.length() != 0) {
            HelpUtilities.debug("  adding ", name1);
            String s = name1.toString();
            tails.addElement(s);
            int lastUnder = s.lastIndexOf(95);
            if (lastUnder == -1) continue;
            name1.setLength(lastUnder);
        }
        HelpUtilities.debug("  addign -- null -- ");
        tails.addElement("");
        if (locale != Locale.getDefault()) {
            String lname2 = Locale.getDefault().toString();
            StringBuffer name2 = new StringBuffer("_").append(lname2);
            if (lname2 == null) {
                name2.setLength(0);
            }
            while (name2.length() != 0) {
                HelpUtilities.debug("  adding ", name2);
                String s = name2.toString();
                tails.addElement(s);
                int lastUnder = s.lastIndexOf(95);
                if (lastUnder == -1) continue;
                name2.setLength(lastUnder);
            }
        }
        tailsPerLocales.put(pair, tails);
        HelpUtilities.debug("tails is == ", tails);
        return tails.elements();
    }

    public static Locale getLocale(Component c) {
        if (c == null) {
            return Locale.getDefault();
        }
        try {
            return c.getLocale();
        }
        catch (IllegalComponentStateException ex) {
            return Locale.getDefault();
        }
    }

    private static synchronized ResourceBundle getBundle(Locale l) {
        ResourceBundle back;
        if (lastLocale == l) {
            return lastBundle;
        }
        if (bundles == null) {
            bundles = new Hashtable();
        }
        if ((back = (ResourceBundle)bundles.get(l)) == null) {
            try {
                back = ResourceBundle.getBundle("javax.help.resources.Constants", l);
            }
            catch (MissingResourceException ex) {
                throw new Error("Fatal: Resource for javahelp is missing");
            }
            bundles.put(l, back);
        }
        lastBundle = back;
        lastLocale = l;
        return back;
    }

    public static String getString(String key) {
        return HelpUtilities.getString(Locale.getDefault(), key);
    }

    public static String getText(String key) {
        return HelpUtilities.getText(Locale.getDefault(), key, null, null);
    }

    public static String getText(String key, String s1) {
        return HelpUtilities.getText(Locale.getDefault(), key, s1, null);
    }

    public static String getText(String key, String s1, String s2) {
        return HelpUtilities.getText(Locale.getDefault(), key, s1, s2);
    }

    public static String getText(String key, String s1, String s2, String s3) {
        return HelpUtilities.getText(Locale.getDefault(), key, s1, s2, s3);
    }

    public static String getString(Locale l, String key) {
        ResourceBundle bundle = HelpUtilities.getBundle(l);
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            throw new Error("Fatal: Localization data for JavaHelp is broken.  Missing " + key + " key.");
        }
    }

    public static String[] getStringArray(Locale l, String key) {
        ResourceBundle bundle = HelpUtilities.getBundle(l);
        try {
            return bundle.getStringArray(key);
        }
        catch (MissingResourceException ex) {
            throw new Error("Fatal: Localization data for JavaHelp is broken.  Missing " + key + " key.");
        }
    }

    public static String getText(Locale l, String key) {
        return HelpUtilities.getText(l, key, null, null, null);
    }

    public static String getText(Locale l, String key, String s1) {
        return HelpUtilities.getText(l, key, s1, null, null);
    }

    public static String getText(Locale l, String key, String s1, String s2) {
        return HelpUtilities.getText(l, key, s1, s2, null);
    }

    public static String getText(Locale l, String key, String s1, String s2, String s3) {
        ResourceBundle bundle = HelpUtilities.getBundle(l);
        if (s1 == null) {
            s1 = "null";
        }
        if (s2 == null) {
            s2 = "null";
        }
        if (s3 == null) {
            s3 = "null";
        }
        try {
            String fmt = bundle.getString(key);
            String[] args = new String[]{s1, s2, s3};
            MessageFormat format = new MessageFormat(fmt);
            try {
                format.setLocale(l);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return format.format(args);
        }
        catch (MissingResourceException ex) {
            throw new Error("Fatal: Localization data for JavaHelp is broken.  Missing " + key + " key.");
        }
    }

    public static Locale localeFromLang(String lang) {
        String variant = null;
        Locale newlocale = null;
        if (lang == null) {
            return newlocale;
        }
        int lpt = lang.indexOf("_");
        int lpt2 = lang.indexOf("-");
        if (lpt == -1 && lpt2 == -1) {
            String language = lang;
            String country = "";
            newlocale = new Locale(language, country);
        } else {
            if (lpt == -1 && lpt2 != -1) {
                lpt = lpt2;
            }
            String language = lang.substring(0, lpt);
            int cpt = lang.indexOf("_", lpt + 1);
            int cpt2 = lang.indexOf("-", lpt + 1);
            if (cpt == -1 && cpt2 == -1) {
                String country = lang.substring(lpt + 1);
                newlocale = new Locale(language, country);
            } else {
                if (cpt == -1 && cpt2 != -1) {
                    cpt = cpt2;
                }
                String country = lang.substring(lpt + 1, cpt);
                variant = lang.substring(cpt + 1);
                newlocale = new Locale(language, country, variant);
            }
        }
        return newlocale;
    }

    public static boolean isStringInString(RuleBasedCollator rbc, String source, String target) {
        block34: {
            HelpUtilities.debug("isStringInString source=" + source + " targe =" + target);
            if (source == null || target == null) {
                return false;
            }
            if (source.length() == 0 && target.length() == 0) {
                return true;
            }
            int strengthResult = 3;
            boolean isFrenchSec = false;
            rbc.setDecomposition(2);
            String rules = rbc.getRules();
            if (rules.startsWith("@")) {
                isFrenchSec = true;
            }
            CollationElementIterator sourceCursor = rbc.getCollationElementIterator(source);
            CollationElementIterator targetCursor = rbc.getCollationElementIterator(target);
            int sOrder = 0;
            int tOrder = 0;
            boolean gets = true;
            boolean gett = true;
            int toffset = 0;
            block9: while (true) {
                boolean checkSecTer;
                block35: {
                    boolean checkTertiary;
                    boolean initialCheckSecTer;
                    int pTOrder;
                    int pSOrder;
                    HelpUtilities.debug("while(true) toffset=" + toffset);
                    try {
                        sourceCursor.setOffset(0);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    sOrder = sourceCursor.next();
                    try {
                        targetCursor.setOffset(toffset);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                    }
                    catch (Exception e) {
                        return false;
                    }
                    tOrder = targetCursor.next();
                    if (tOrder == -1) break block34;
                    HelpUtilities.debug("sOrder=" + sOrder + " tOrder=" + tOrder);
                    while (tOrder != -1) {
                        if (sOrder == tOrder) {
                            try {
                                toffset = targetCursor.getOffset();
                            }
                            catch (NoSuchMethodError noSuchMethodError) {}
                            break;
                        }
                        pSOrder = CollationElementIterator.primaryOrder(sOrder);
                        if (pSOrder == (pTOrder = CollationElementIterator.primaryOrder(tOrder))) {
                            try {
                                toffset = targetCursor.getOffset();
                            }
                            catch (NoSuchMethodError noSuchMethodError) {}
                            break;
                        }
                        tOrder = targetCursor.next();
                        HelpUtilities.debug("next tOrder=" + tOrder);
                    }
                    if (tOrder == -1) {
                        return false;
                    }
                    gets = false;
                    gett = false;
                    checkSecTer = initialCheckSecTer = rbc.getStrength() >= 1;
                    boolean bl = checkTertiary = rbc.getStrength() >= 2;
                    while (true) {
                        short terTOrder;
                        short terSOrder;
                        short secTOrder;
                        if (gets) {
                            sOrder = sourceCursor.next();
                        } else {
                            gets = true;
                        }
                        if (gett) {
                            tOrder = targetCursor.next();
                        } else {
                            gett = true;
                        }
                        if (sOrder == -1 || tOrder == -1) break block35;
                        pSOrder = CollationElementIterator.primaryOrder(sOrder);
                        pTOrder = CollationElementIterator.primaryOrder(tOrder);
                        if (sOrder == tOrder) {
                            if (isFrenchSec && pSOrder != 0 && !checkSecTer) {
                                checkSecTer = initialCheckSecTer;
                                checkTertiary = false;
                            }
                            HelpUtilities.debug("No diff at this positon continue");
                            continue;
                        }
                        if (pSOrder != pTOrder) {
                            if (sOrder == 0) {
                                gett = false;
                                continue;
                            }
                            if (tOrder == 0) {
                                gets = false;
                                continue;
                            }
                            if (pSOrder == 0) {
                                if (checkSecTer) {
                                    targetCursor.next();
                                    toffset = targetCursor.getOffset();
                                    HelpUtilities.debug("Strength is secondary pSOrder === 0");
                                    continue block9;
                                }
                                gett = false;
                                continue;
                            }
                            if (pTOrder == 0) {
                                if (checkSecTer) {
                                    targetCursor.next();
                                    toffset = targetCursor.getOffset();
                                    HelpUtilities.debug("Strength is secondary - pTOrder == 0");
                                    continue block9;
                                }
                                gets = false;
                                continue;
                            }
                            targetCursor.next();
                            toffset = targetCursor.getOffset();
                            HelpUtilities.debug("Order are ignorable");
                            continue block9;
                        }
                        if (!checkSecTer) continue;
                        short secSOrder = CollationElementIterator.secondaryOrder(sOrder);
                        if (secSOrder != (secTOrder = CollationElementIterator.secondaryOrder(tOrder))) {
                            targetCursor.next();
                            toffset = targetCursor.getOffset();
                            HelpUtilities.debug("Secondary Difference");
                            continue block9;
                        }
                        if (checkTertiary && (terSOrder = CollationElementIterator.tertiaryOrder(sOrder)) != (terTOrder = CollationElementIterator.tertiaryOrder(tOrder))) break;
                    }
                    targetCursor.next();
                    toffset = targetCursor.getOffset();
                    HelpUtilities.debug("Tertiary difference");
                    continue;
                }
                HelpUtilities.debug("One string at end");
                if (sOrder == -1) break;
                do {
                    if (CollationElementIterator.primaryOrder(sOrder) != 0) {
                        targetCursor.next();
                        toffset = targetCursor.getOffset();
                        HelpUtilities.debug("Additional non-ignborable base character in source string - source is greater");
                        continue block9;
                    }
                    if (CollationElementIterator.secondaryOrder(sOrder) == 0 || !checkSecTer) continue;
                    targetCursor.next();
                    toffset = targetCursor.getOffset();
                    HelpUtilities.debug("Additional secondary elements source is greater");
                    continue block9;
                } while ((sOrder = sourceCursor.next()) != -1);
                break;
            }
            return true;
        }
        return false;
    }

    private static void debug(Object msg1, Object msg2, Object msg3) {
    }

    private static void debug(Object msg1) {
        HelpUtilities.debug(msg1, "", "");
    }

    private static void debug(Object msg1, Object msg2) {
        HelpUtilities.debug(msg1, msg2, "");
    }

    static {
        lastBundle = null;
        lastLocale = null;
    }

    static class LocalePair {
        Locale locale1;
        Locale locale2;

        LocalePair(Locale locale1, Locale locale2) {
            this.locale1 = locale1;
            this.locale2 = locale2;
        }

        public int hashCode() {
            return this.locale1.hashCode() + this.locale2.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof LocalePair)) {
                return false;
            }
            LocalePair p = (LocalePair)obj;
            return this.locale1.equals(p.locale1) && this.locale2.equals(p.locale2);
        }
    }
}

