/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import com.sun.java.help.impl.LangElement;
import com.sun.java.help.impl.Parser;
import com.sun.java.help.impl.ParserEvent;
import com.sun.java.help.impl.ParserListener;
import com.sun.java.help.impl.Tag;
import com.sun.java.help.impl.TagProperties;
import com.sun.java.help.impl.XmlReader;
import java.awt.Component;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import javax.help.BadIDException;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.IndexItem;
import javax.help.JHelpIndexNavigator;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.TreeItem;
import javax.help.TreeItemFactory;
import javax.swing.tree.DefaultMutableTreeNode;

public class IndexView
extends NavigatorView {
    public static final String publicIDString = "-//Sun Microsystems Inc.//DTD JavaHelp Index Version 1.0//EN";
    public static final String publicIDString_V2 = "-//Sun Microsystems Inc.//DTD JavaHelp Index Version 2.0//EN";
    private static boolean warningOfFailures = false;
    private static final boolean debug = false;

    public IndexView(HelpSet hs, String name, String label, Hashtable params) {
        super(hs, name, label, hs.getLocale(), params);
    }

    public IndexView(HelpSet hs, String name, String label, Locale locale, Hashtable params) {
        super(hs, name, label, locale, params);
    }

    @Override
    public Component createNavigator(HelpModel model) {
        return new JHelpIndexNavigator(this, model);
    }

    @Override
    public String getMergeType() {
        String mergeType = super.getMergeType();
        if (mergeType == null) {
            return "javax.help.AppendMerge";
        }
        return mergeType;
    }

    public DefaultMutableTreeNode getDataAsTree() {
        URL url;
        HelpSet hs = this.getHelpSet();
        IndexView.debug("helpSet in " + this + hs.toString());
        Hashtable params = this.getParameters();
        if (params == null || params != null && !params.containsKey("data")) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode();
            return node;
        }
        try {
            url = new URL(hs.getHelpSetURL(), (String)params.get("data"));
        }
        catch (Exception ex) {
            throw new Error("Trouble getting URL to Index data; " + ex);
        }
        IndexView.debug("url,hs: " + url.toString() + ";" + hs.toString());
        return IndexView.parse(url, hs, hs.getLocale(), new DefaultIndexFactory());
    }

    public static DefaultMutableTreeNode parse(URL url, HelpSet hs, Locale locale, TreeItemFactory factory) {
        DefaultMutableTreeNode node = null;
        try {
            URLConnection uc = url.openConnection();
            Reader src = XmlReader.createReader(uc);
            factory.parsingStarted(url);
            node = new IndexParser(factory).parse(src, hs, locale);
            src.close();
        }
        catch (Exception e) {
            factory.reportMessage("Exception caught while parsing " + url + e.toString(), false);
        }
        return factory.parsingEnded(node);
    }

    private static void debug(String msg) {
    }

    public static class DefaultIndexFactory
    implements TreeItemFactory {
        private Vector messages = new Vector();
        private URL source;
        private boolean validParse = true;

        @Override
        public void parsingStarted(URL source) {
            if (source == null) {
                throw new NullPointerException("source");
            }
            this.source = source;
        }

        @Override
        public void processDOCTYPE(String root, String publicID, String systemID) {
            if (publicID == null || publicID.compareTo(IndexView.publicIDString) != 0 && publicID.compareTo(IndexView.publicIDString_V2) != 0) {
                this.reportMessage(HelpUtilities.getText("index.invalidIndexFormat", publicID), false);
            }
        }

        @Override
        public void processPI(HelpSet hs, String target, String data) {
        }

        @Override
        public TreeItem createItem(String tagName, Hashtable atts, HelpSet hs, Locale locale) {
            if (tagName == null || !tagName.equals("indexitem")) {
                throw new IllegalArgumentException("tagName");
            }
            IndexItem item = null;
            String id = null;
            String text = null;
            String mergeType = null;
            String expand = null;
            String presentation = null;
            String presentationName = null;
            if (atts != null) {
                id = (String)atts.get("target");
                text = (String)atts.get("text");
                mergeType = (String)atts.get("mergetype");
                expand = (String)atts.get("expand");
                presentation = (String)atts.get("presentationtype");
                presentationName = (String)atts.get("presentationname");
            }
            try {
                item = new IndexItem(Map.ID.create(id, hs), hs, locale);
            }
            catch (BadIDException ex) {
                item = new IndexItem();
            }
            if (text != null) {
                item.setName(text);
            }
            if (mergeType != null) {
                item.setMergeType(mergeType);
            }
            if (expand != null) {
                if (expand.equals("true")) {
                    item.setExpansionType(1);
                } else if (expand.equals("false")) {
                    item.setExpansionType(0);
                }
            }
            if (presentation != null) {
                item.setPresentation(presentation);
            }
            if (presentationName != null) {
                item.setPresentationName(presentationName);
            }
            return item;
        }

        @Override
        public TreeItem createItem() {
            return new IndexItem();
        }

        @Override
        public void reportMessage(String msg, boolean validParse) {
            this.messages.addElement(msg);
            this.validParse = this.validParse && validParse;
        }

        @Override
        public Enumeration listMessages() {
            return this.messages.elements();
        }

        @Override
        public DefaultMutableTreeNode parsingEnded(DefaultMutableTreeNode node) {
            DefaultMutableTreeNode back = node;
            if (!this.validParse) {
                back = null;
                System.err.println("Parsing failed for " + this.source);
                Enumeration e = this.messages.elements();
                while (e.hasMoreElements()) {
                    String msg = (String)e.nextElement();
                    System.err.println(msg);
                }
            }
            return back;
        }
    }

    private static class IndexParser
    implements ParserListener {
        private HelpSet currentParseHS;
        private Stack nodeStack;
        private Stack itemStack;
        private Stack tagStack;
        private Locale defaultLocale;
        private Locale lastLocale;
        private boolean startedindex;
        private TreeItemFactory factory;

        IndexParser(TreeItemFactory factory) {
            this.factory = factory;
        }

        synchronized DefaultMutableTreeNode parse(Reader src, HelpSet context, Locale locale) throws IOException {
            this.nodeStack = new Stack();
            this.itemStack = new Stack();
            this.tagStack = new Stack();
            this.defaultLocale = locale == null ? Locale.getDefault() : locale;
            this.lastLocale = this.defaultLocale;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode();
            this.nodeStack.push(node);
            this.currentParseHS = context;
            Parser parser = new Parser(src);
            parser.addParserListener(this);
            parser.parse();
            return node;
        }

        @Override
        public void tagFound(ParserEvent e) {
            Locale locale = null;
            Tag tag = e.getTag();
            TagProperties attr = tag.atts;
            if (attr != null) {
                String lang = attr.getProperty("xml:lang");
                locale = HelpUtilities.localeFromLang(lang);
            }
            if (locale == null) {
                locale = this.lastLocale;
            }
            if (tag.name.equals("indexitem")) {
                if (!this.startedindex) {
                    this.factory.reportMessage(HelpUtilities.getText("index.invalidIndexFormat"), false);
                }
                if (tag.isEnd && !tag.isEmpty) {
                    this.nodeStack.pop();
                    this.itemStack.pop();
                    this.removeTag(tag);
                    return;
                }
                TreeItem item = null;
                try {
                    Hashtable t = null;
                    if (attr != null) {
                        t = attr.getHashtable();
                    }
                    item = this.factory.createItem("indexitem", t, this.currentParseHS, locale);
                }
                catch (Exception ex) {
                    if (warningOfFailures) {
                        String id = null;
                        if (attr != null) {
                            id = attr.getProperty("target");
                        }
                        System.err.println("Failure in IndexItem Creation; ");
                        System.err.println("  id: " + id);
                        System.err.println("  hs: " + this.currentParseHS);
                    }
                    item = this.factory.createItem();
                }
                if (!this.itemStack.empty()) {
                    IndexItem parent = (IndexItem)this.itemStack.peek();
                    if (item.getExpansionType() == -1 && parent != null && parent.getExpansionType() != -1) {
                        item.setExpansionType(parent.getExpansionType());
                    }
                }
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(item);
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.nodeStack.peek();
                parent.add(node);
                if (!tag.isEmpty) {
                    this.itemStack.push(item);
                    this.nodeStack.push(node);
                    this.addTag(tag, locale);
                }
            } else if (tag.name.equals("index")) {
                if (!tag.isEnd) {
                    String version;
                    if (attr != null && (version = attr.getProperty("version")) != null && version.compareTo("1.0") != 0 && version.compareTo("2.0") != 0) {
                        this.factory.reportMessage(HelpUtilities.getText("index.unknownVersion", version), false);
                    }
                    if (this.startedindex) {
                        this.factory.reportMessage(HelpUtilities.getText("index.invalidIndexFormat"), false);
                    }
                    this.startedindex = true;
                    this.addTag(tag, locale);
                } else {
                    if (this.startedindex) {
                        this.startedindex = false;
                    }
                    this.removeTag(tag);
                }
                return;
            }
        }

        @Override
        public void piFound(ParserEvent e) {
        }

        @Override
        public void doctypeFound(ParserEvent e) {
            this.factory.processDOCTYPE(e.getRoot(), e.getPublicId(), e.getSystemId());
        }

        @Override
        public void textFound(ParserEvent e) {
            if (this.tagStack.empty()) {
                return;
            }
            LangElement le = (LangElement)this.tagStack.peek();
            Tag tag = le.getTag();
            if (tag.name.equals("indexitem")) {
                IndexItem item = (IndexItem)this.itemStack.peek();
                String oldName = item.getName();
                if (oldName == null) {
                    item.setName(e.getText().trim());
                } else {
                    item.setName(oldName.concat(e.getText()).trim());
                }
            }
        }

        @Override
        public void commentFound(ParserEvent e) {
        }

        @Override
        public void errorFound(ParserEvent e) {
            this.factory.reportMessage(e.getText(), false);
        }

        protected void addTag(Tag tag, Locale locale) {
            LangElement el = new LangElement(tag, locale);
            this.tagStack.push(el);
            if (this.lastLocale == null) {
                this.lastLocale = locale;
                return;
            }
            if (locale == null) {
                this.lastLocale = locale;
                return;
            }
            if (!this.lastLocale.equals(locale)) {
                this.lastLocale = locale;
            }
        }

        protected void removeTag(Tag tag) {
            String name = tag.name;
            Locale newLocale = null;
            while (!this.tagStack.empty()) {
                LangElement el = (LangElement)this.tagStack.pop();
                if (el.getTag().name.equals(name)) continue;
                if (this.tagStack.empty()) {
                    newLocale = this.defaultLocale;
                    break;
                }
                el = (LangElement)this.tagStack.peek();
                newLocale = el.getLocale();
                break;
            }
            if (this.lastLocale == null) {
                this.lastLocale = newLocale;
                return;
            }
            if (newLocale == null) {
                this.lastLocale = newLocale;
                return;
            }
            if (!this.lastLocale.equals(newLocale)) {
                this.lastLocale = newLocale;
            }
        }
    }
}

