/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.net.URL;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.help.BadIDException;
import javax.help.DefaultHelpModel;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.Map;
import javax.help.SwingHelpUtilities;
import javax.help.TextHelpModel;
import javax.help.event.HelpModelListener;
import javax.help.event.TextHelpModelListener;
import javax.help.plaf.HelpContentViewerUI;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.EditorKit;

public class JHelpContentViewer
extends JComponent
implements Accessible {
    protected TextHelpModel model;
    private boolean synch = true;
    private Hashtable kitRegistry;
    private boolean debug = false;

    public JHelpContentViewer(HelpSet hs) {
        this.setModel(new DefaultHelpModel(hs));
        this.updateUI();
    }

    public JHelpContentViewer() {
        this.setModel(new DefaultHelpModel(null));
        this.updateUI();
    }

    public JHelpContentViewer(TextHelpModel model) {
        this.setModel(model);
        this.updateUI();
    }

    public void setModel(TextHelpModel newModel) {
        this.debug("setModel: " + newModel);
        TextHelpModel oldModel = this.model;
        if (newModel != oldModel) {
            this.model = newModel;
            this.firePropertyChange("helpModel", oldModel, this.model);
            this.invalidate();
        }
    }

    public TextHelpModel getModel() {
        return this.model;
    }

    public void setUI(HelpContentViewerUI ui) {
        this.debug("setUI");
        if ((HelpContentViewerUI)this.ui != ui) {
            super.setUI(ui);
            this.repaint();
        }
    }

    @Override
    public HelpContentViewerUI getUI() {
        return (HelpContentViewerUI)this.ui;
    }

    @Override
    public void updateUI() {
        SwingHelpUtilities.installUIDefaults();
        this.setUI((HelpContentViewerUI)UIManager.getUI(this));
        this.invalidate();
    }

    @Override
    public String getUIClassID() {
        return "HelpContentViewerUI";
    }

    public void setCurrentID(Map.ID id) throws InvalidHelpSetContextException {
        this.model.setCurrentID(id);
    }

    public void setCurrentID(String id) throws BadIDException {
        try {
            this.model.setCurrentID(Map.ID.create(id, this.getModel().getHelpSet()));
        }
        catch (InvalidHelpSetContextException invalidHelpSetContextException) {
            // empty catch block
        }
    }

    public void setCurrentURL(URL url) {
        this.model.setCurrentURL(url);
    }

    public URL getCurrentURL() {
        return this.model.getCurrentURL();
    }

    public String getDocumentTitle() {
        return this.model.getDocumentTitle();
    }

    public void addHighlight(int p0, int p1) {
        this.model.addHighlight(p0, p1);
    }

    public void removeAllHighlights() {
        this.model.removeAllHighlights();
    }

    public void setSynch(boolean value) {
        this.synch = value;
    }

    public boolean getSynch() {
        return this.synch;
    }

    public EditorKit createEditorKitForContentType(String type) {
        EditorKit k = null;
        if (this.kitRegistry == null) {
            this.kitRegistry = new Hashtable();
        } else {
            k = (EditorKit)this.kitRegistry.get(type);
        }
        if (k == null) {
            HelpSet hs = this.model.getHelpSet();
            String classname = (String)hs.getKeyData(HelpSet.kitTypeRegistry, type);
            if (classname == null) {
                return null;
            }
            ClassLoader loader = (ClassLoader)hs.getKeyData(HelpSet.kitLoaderRegistry, type);
            if (loader == null) {
                loader = hs.getLoader();
            }
            try {
                Class<?> c = loader != null ? loader.loadClass(classname) : Class.forName(classname);
                k = (EditorKit)c.newInstance();
                this.kitRegistry.put(type, k);
            }
            catch (Throwable e) {
                e.printStackTrace();
                k = null;
            }
        }
        if (k != null) {
            return (EditorKit)k.clone();
        }
        k = JEditorPane.createEditorKitForContentType(type);
        return k;
    }

    public void addTextHelpModelListener(TextHelpModelListener l) {
        this.getModel().addTextHelpModelListener(l);
    }

    public void removeHelpModelListener(TextHelpModelListener l) {
        this.getModel().removeTextHelpModelListener(l);
    }

    public void addHelpModelListener(HelpModelListener l) {
        this.getModel().addHelpModelListener(l);
    }

    public void removeHelpModelListener(HelpModelListener l) {
        this.getModel().removeHelpModelListener(l);
    }

    public void clear() {
        this.firePropertyChange("clear", " ", "xyz");
    }

    public void reload() {
        this.firePropertyChange("reload", " ", "xyz");
    }

    private void debug(String msg) {
        if (this.debug) {
            System.err.println("JHelpContentViewer: " + msg);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJHelpContentViewer();
        }
        return this.accessibleContext;
    }

    static {
        SwingHelpUtilities.installLookAndFeelDefaults();
    }

    protected class AccessibleJHelpContentViewer
    extends JComponent.AccessibleJComponent {
        protected AccessibleJHelpContentViewer() {
            super(JHelpContentViewer.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }
}

