/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.lang.reflect.Constructor;
import java.util.Locale;
import javax.help.AppendMerge;
import javax.help.HelpSet;
import javax.help.IndexView;
import javax.help.NavigatorView;
import javax.help.TOCView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public abstract class Merge {
    protected DefaultMutableTreeNode slaveTopNode;
    protected Locale locale;

    protected Merge(NavigatorView master, NavigatorView slave) {
        try {
            Class<?> clss = Class.forName("javax.help.TOCView");
            if (clss.isInstance(slave)) {
                this.slaveTopNode = ((TOCView)slave).getDataAsTree();
            }
            if ((clss = Class.forName("javax.help.IndexView")).isInstance(slave)) {
                this.slaveTopNode = ((IndexView)slave).getDataAsTree();
            }
        }
        catch (ClassNotFoundException exp) {
            System.err.println(exp);
        }
        this.locale = master.getHelpSet().getLocale();
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
    }

    public abstract TreeNode processMerge(TreeNode var1);

    public static void mergeNodes(TreeNode master, TreeNode slave) {
    }

    public static void mergeNodeChildren(TreeNode node) {
    }

    public static class DefaultMergeFactory {
        public static Merge getMerge(NavigatorView masterView, NavigatorView slaveView) {
            Merge mergeObject = null;
            if (masterView == null || slaveView == null) {
                throw new NullPointerException("masterView and/or slaveView are null");
            }
            String mergeType = masterView.getMergeType();
            HelpSet hs = masterView.getHelpSet();
            Locale locale = hs.getLocale();
            ClassLoader loader = hs.getLoader();
            if (mergeType != null) {
                try {
                    Class[] types = new Class[]{NavigatorView.class, NavigatorView.class};
                    Object[] args = new Object[]{masterView, slaveView};
                    Class<?> klass = loader == null ? Class.forName(mergeType) : loader.loadClass(mergeType);
                    Constructor<?> konstructor = klass.getConstructor(types);
                    mergeObject = (Merge)konstructor.newInstance(args);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new RuntimeException("Could not create Merge type " + mergeType);
                }
            } else {
                mergeObject = new AppendMerge(masterView, slaveView);
            }
            return mergeObject;
        }
    }
}

