/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.Point;
import java.net.URL;
import java.util.Locale;
import javax.help.BadIDException;
import javax.help.DefaultHelpModel;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.UnsupportedOperationException;

public class ServletHelpBroker
implements HelpBroker {
    protected HelpSet helpset = null;
    protected DefaultHelpModel model = null;
    protected NavigatorView curNav = null;
    protected boolean viewDisplayed = true;
    protected Locale locale = null;
    protected Font font;
    private static final boolean debug = false;

    @Override
    public HelpSet getHelpSet() {
        return this.helpset;
    }

    @Override
    public void setHelpSet(HelpSet hs) {
        if (hs != null && this.helpset != hs) {
            this.model = new DefaultHelpModel(hs);
            this.helpset = hs;
        }
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    @Override
    public void setLocale(Locale l) {
        this.locale = l;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font f) {
        this.font = f;
    }

    @Override
    public void setCurrentView(String name) {
        NavigatorView[] views = this.helpset.getNavigatorViews();
        for (int i = 0; i < views.length; ++i) {
            if (!views[i].getName().equals(name)) continue;
            this.curNav = views[i];
            return;
        }
        throw new IllegalArgumentException("Invalid view name");
    }

    @Override
    public String getCurrentView() {
        if (this.curNav == null) {
            if (this.helpset != null) {
                NavigatorView[] views = this.helpset.getNavigatorViews();
                this.curNav = views[0];
            } else {
                return null;
            }
        }
        return this.curNav.getName();
    }

    public NavigatorView getCurrentNavigatorView() {
        if (this.curNav == null) {
            if (this.helpset != null) {
                NavigatorView[] views = this.helpset.getNavigatorViews();
                this.curNav = views[0];
            } else {
                return null;
            }
        }
        return this.curNav;
    }

    @Override
    public void initPresentation() {
    }

    @Override
    public void setDisplayed(boolean b) {
    }

    @Override
    public boolean isDisplayed() {
        return true;
    }

    @Override
    public void setLocation(Point p) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented in ServeltHelpBroker");
    }

    @Override
    public Point getLocation() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented in ServeltHelpBroker");
    }

    @Override
    public void setSize(Dimension d) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented in ServeltHelpBroker");
    }

    @Override
    public Dimension getSize() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented in ServeltHelpBroker");
    }

    @Override
    public void setScreen(int screen) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented in ServeltHelpBroker");
    }

    @Override
    public int getScreen() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented in ServeltHelpBroker");
    }

    @Override
    public void setViewDisplayed(boolean displayed) {
        this.viewDisplayed = displayed;
    }

    @Override
    public boolean isViewDisplayed() {
        return this.viewDisplayed;
    }

    @Override
    public void setCurrentID(String id) throws BadIDException {
        try {
            this.setCurrentID(Map.ID.create(id, this.helpset));
        }
        catch (InvalidHelpSetContextException ex) {
            new Error("internal error?");
        }
    }

    @Override
    public void setCurrentID(Map.ID id) throws InvalidHelpSetContextException {
        ServletHelpBroker.debug("setCurrentID");
        this.model.setCurrentID(id);
    }

    @Override
    public Map.ID getCurrentID() {
        return this.model.getCurrentID();
    }

    @Override
    public void setCurrentURL(URL url) {
        this.model.setCurrentURL(url);
    }

    @Override
    public URL getCurrentURL() {
        return this.model.getCurrentURL();
    }

    @Override
    public void enableHelpKey(Component comp, String id, HelpSet hs) {
    }

    @Override
    public void enableHelp(Component comp, String id, HelpSet hs) {
    }

    @Override
    public void enableHelp(MenuItem comp, String id, HelpSet hs) {
    }

    @Override
    public void enableHelpOnButton(Component comp, String id, HelpSet hs) {
    }

    @Override
    public void enableHelpOnButton(MenuItem comp, String id, HelpSet hs) {
    }

    @Override
    public void setHelpSetPresentation(HelpSet.Presentation pres) {
    }

    @Override
    public void showID(String id, String presentation, String presentationName) throws BadIDException {
    }

    @Override
    public void showID(Map.ID id, String presentation, String presentationName) throws InvalidHelpSetContextException {
    }

    @Override
    public void enableHelpKey(Component comp, String id, HelpSet hs, String presentation, String presentationName) {
    }

    @Override
    public void enableHelpOnButton(Object obj, String id, HelpSet hs, String presentation, String presentationName) {
    }

    private static void debug(Object msg) {
    }
}

