/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.text.CollationKey;
import java.text.Collator;
import java.util.Arrays;
import java.util.Locale;
import javax.help.Merge;
import javax.help.MergeHelpUtilities;
import javax.help.NavigatorView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class SortMerge
extends Merge {
    private static boolean debug = false;

    public SortMerge(NavigatorView master, NavigatorView slave) {
        super(master, slave);
    }

    @Override
    public TreeNode processMerge(TreeNode node) {
        SortMerge.debug("processMerge started");
        DefaultMutableTreeNode masterNode = (DefaultMutableTreeNode)node;
        if (masterNode.equals(this.slaveTopNode)) {
            return masterNode;
        }
        if (this.slaveTopNode.getChildCount() == 0) {
            return masterNode;
        }
        if (masterNode.getChildCount() == 0) {
            MergeHelpUtilities.mergeNodeChildren("javax.help.SortMerge", this.slaveTopNode);
            while (this.slaveTopNode.getChildCount() > 0) {
                masterNode.add((DefaultMutableTreeNode)this.slaveTopNode.getFirstChild());
            }
            return masterNode;
        }
        SortMerge.mergeNodes(masterNode, this.slaveTopNode);
        SortMerge.debug("process merge ended");
        return masterNode;
    }

    public static void mergeNodes(TreeNode master, TreeNode slave) {
        SortMerge.debug("mergeNodes started");
        DefaultMutableTreeNode masterNode = (DefaultMutableTreeNode)master;
        DefaultMutableTreeNode slaveNode = (DefaultMutableTreeNode)slave;
        SortMerge.sortNode(slaveNode, MergeHelpUtilities.getLocale(slaveNode));
        int masterCnt = masterNode.getChildCount();
        int m = 0;
        DefaultMutableTreeNode masterAtM = null;
        if (masterCnt > 0) {
            masterAtM = (DefaultMutableTreeNode)masterNode.getChildAt(m);
        }
        DefaultMutableTreeNode slaveNodeChild = null;
        while (slaveNode.getChildCount() > 0 && masterAtM != null) {
            slaveNodeChild = (DefaultMutableTreeNode)slaveNode.getFirstChild();
            int compareVal = MergeHelpUtilities.compareNames(masterAtM, slaveNodeChild);
            if (compareVal < 0) {
                if (++m >= masterCnt) break;
                masterAtM = (DefaultMutableTreeNode)masterNode.getChildAt(m);
                continue;
            }
            if (compareVal > 0) {
                masterNode.add(slaveNodeChild);
                MergeHelpUtilities.mergeNodeChildren("javax.help.SortMerge", slaveNodeChild);
                continue;
            }
            if (MergeHelpUtilities.haveEqualID(masterAtM, slaveNodeChild)) {
                MergeHelpUtilities.mergeNodes("javax.help.SortMerge", masterAtM, slaveNodeChild);
                slaveNodeChild.removeFromParent();
                slaveNodeChild = null;
                continue;
            }
            MergeHelpUtilities.markNodes(masterAtM, slaveNodeChild);
            masterNode.add(slaveNodeChild);
            MergeHelpUtilities.mergeNodeChildren("javax.help.SortMerge", slaveNodeChild);
        }
        while (slaveNode.getChildCount() > 0) {
            slaveNodeChild = (DefaultMutableTreeNode)slaveNode.getFirstChild();
            masterNode.add(slaveNodeChild);
            MergeHelpUtilities.mergeNodeChildren("javax.help.SortMerge", slaveNodeChild);
        }
        SortMerge.mergeNodeChildren(masterNode);
        SortMerge.debug("mergeNode ended");
    }

    public static void mergeNodeChildren(TreeNode node) {
        DefaultMutableTreeNode masterNode = (DefaultMutableTreeNode)node;
        SortMerge.debug("mergeNodeChildren master=" + MergeHelpUtilities.getNodeName(masterNode));
        SortMerge.sortNode(masterNode, MergeHelpUtilities.getLocale(masterNode));
        for (int i = 0; i < masterNode.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)masterNode.getChildAt(i);
            if (child.isLeaf()) continue;
            MergeHelpUtilities.mergeNodeChildren("javax.help.SortMerge", child);
        }
    }

    public static void sortNode(DefaultMutableTreeNode node, Locale locale) {
        int i;
        SortMerge.debug("sortNode");
        if (locale == null) {
            locale = Locale.getDefault();
        }
        int size = node.getChildCount();
        DefaultMutableTreeNode sortedNode = new DefaultMutableTreeNode();
        Collator collator = Collator.getInstance(locale);
        Object[] keys = new CollationKey[size];
        for (i = 0; i < size; ++i) {
            String string = MergeHelpUtilities.getNodeName((DefaultMutableTreeNode)node.getChildAt(i));
            SortMerge.debug("String , i:" + string + " , " + i);
            keys[i] = collator.getCollationKey(string);
        }
        Arrays.sort(keys);
        for (i = 0; i < size; ++i) {
            DefaultMutableTreeNode child = MergeHelpUtilities.getChildWithName(node, ((CollationKey)keys[i]).getSourceString());
            if (child == null) continue;
            sortedNode.add(child);
        }
        while (sortedNode.getChildCount() > 0) {
            node.add((DefaultMutableTreeNode)sortedNode.getFirstChild());
        }
        SortMerge.debug("end sortNode");
    }

    private static void debug(String msg) {
        if (debug) {
            System.out.println("SortMerge :" + msg);
        }
    }
}

