/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Locale;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpContentViewer;
import javax.help.Map;
import javax.help.TextHelpModel;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.event.TextHelpModelEvent;
import javax.help.event.TextHelpModelListener;
import javax.help.plaf.HelpContentViewerUI;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Highlighter;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.StyleSheet;
import javax.swing.text.html.parser.ParserDelegator;

public class BasicContentViewerUI
extends HelpContentViewerUI
implements HelpModelListener,
TextHelpModelListener,
HyperlinkListener,
PropertyChangeListener,
Serializable {
    protected JHelpContentViewer theViewer;
    private static Dimension PREF_SIZE = new Dimension(200, 300);
    private static Dimension MIN_SIZE = new Dimension(80, 80);
    private JEditorPane html;
    private JViewport vp;
    private Hashtable registry;
    private boolean loadingURL;
    private TextHelpModelEvent pendingHighlightsEvent;
    private static final boolean debug = false;
    private static final boolean debug1 = false;

    public static ComponentUI createUI(JComponent x) {
        BasicContentViewerUI.debug("createUI");
        return new BasicContentViewerUI((JHelpContentViewer)x);
    }

    public BasicContentViewerUI(JHelpContentViewer b) {
        BasicContentViewerUI.debug("createUI - sort of");
    }

    public void setEditorKit(String type, EditorKit kit) {
        BasicContentViewerUI.debug("setEditorKit(" + type + ", " + kit + ")");
        if (this.registry == null) {
            this.registry = new Hashtable(3);
        }
        this.registry.put(type, kit);
        if (this.html != null) {
            BasicContentViewerUI.debug("  type: " + type);
            BasicContentViewerUI.debug("  kit: " + kit);
            this.html.setEditorKitForContentType(type, kit);
        }
    }

    @Override
    public void installUI(JComponent c) {
        URL url;
        BasicContentViewerUI.debug("installUI");
        this.theViewer = (JHelpContentViewer)c;
        this.theViewer.setLayout(new BorderLayout());
        this.theViewer.addPropertyChangeListener(this);
        TextHelpModel model = this.theViewer.getModel();
        if (model != null) {
            model.addHelpModelListener(this);
            model.addTextHelpModelListener(this);
        }
        this.html = new JHEditorPane();
        this.html.addPropertyChangeListener(this);
        this.html.getAccessibleContext().setAccessibleName(HelpUtilities.getString(HelpUtilities.getLocale(this.html), "access.contentViewer"));
        this.html.setEditable(false);
        this.html.addHyperlinkListener(this);
        if (model != null && (url = model.getCurrentURL()) != null) {
            try {
                this.html.setPage(url);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        JScrollPane scroller = new JScrollPane();
        scroller.setBorder(new BevelBorder(1, Color.white, Color.gray));
        this.vp = scroller.getViewport();
        this.vp.add(this.html);
        this.vp.setBackingStoreEnabled(true);
        this.theViewer.add("Center", scroller);
        this.loadingURL = false;
        this.pendingHighlightsEvent = null;
    }

    @Override
    public void uninstallUI(JComponent c) {
        BasicContentViewerUI.debug("uninstallUI");
        JHelpContentViewer viewer = (JHelpContentViewer)c;
        viewer.removePropertyChangeListener(this);
        this.html.removePropertyChangeListener(this);
        TextHelpModel model = viewer.getModel();
        if (model != null) {
            model.removeHelpModelListener(this);
            model.removeTextHelpModelListener(this);
        }
        viewer.setLayout(null);
        viewer.removeAll();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return PREF_SIZE;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return MIN_SIZE;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void idChanged(HelpModelEvent e) {
        Map.ID id = e.getID();
        URL url = e.getURL();
        TextHelpModel model = this.theViewer.getModel();
        BasicContentViewerUI.debug("idChanged(" + e + ")");
        BasicContentViewerUI.debug("  = " + id + " " + url);
        BasicContentViewerUI.debug("  my helpModel: " + model);
        model.setDocumentTitle(null);
        try {
            Highlighter h = this.html.getHighlighter();
            BasicContentViewerUI.debug("removeAllHighlights");
            h.removeAllHighlights();
            try {
                this.loadingURL = true;
                this.html.setPage(url);
            }
            catch (Exception ex) {
                this.loadingURL = false;
            }
            BasicContentViewerUI.debug("html current EditorKit is: " + this.html.getEditorKit());
            BasicContentViewerUI.debug("html current ContentType is: " + this.html.getContentType());
        }
        catch (Exception e3) {
            BasicContentViewerUI.debug("Exception geneartated");
        }
        BasicContentViewerUI.debug("done with idChanged");
    }

    private void rebuild() {
        BasicContentViewerUI.debug("rebuild");
        TextHelpModel model = this.theViewer.getModel();
        if (model == null) {
            BasicContentViewerUI.debug("rebuild-end: model is null");
            return;
        }
        Highlighter h = this.html.getHighlighter();
        BasicContentViewerUI.debug("removeAllHighlights");
        h.removeAllHighlights();
        HelpSet hs = model.getHelpSet();
        if (this.theViewer.getSynch()) {
            try {
                Map.ID homeID = hs.getHomeID();
                Locale locale = hs.getLocale();
                String name = HelpUtilities.getString(locale, "history.homePage");
                model.setCurrentID(homeID, name, null);
                this.html.setPage(model.getCurrentURL());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        BasicContentViewerUI.debug("rebuild-end");
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String changeName;
        BasicContentViewerUI.debug("propertyChange: " + event.getPropertyName() + "\n\toldValue:" + event.getOldValue() + "\n\tnewValue:" + event.getNewValue());
        if (event.getSource() == this.theViewer) {
            URL url;
            String changeName2 = event.getPropertyName();
            if (changeName2.equals("helpModel")) {
                TextHelpModel oldModel = (TextHelpModel)event.getOldValue();
                TextHelpModel newModel = (TextHelpModel)event.getNewValue();
                if (oldModel != null) {
                    oldModel.removeHelpModelListener(this);
                    oldModel.removeTextHelpModelListener(this);
                }
                if (newModel != null) {
                    newModel.addHelpModelListener(this);
                    newModel.addTextHelpModelListener(this);
                }
                this.rebuild();
            } else if (changeName2.equals("font")) {
                BasicContentViewerUI.debug("font changed");
                Font newFont = (Font)event.getNewValue();
                EditorKit ek = this.html.getEditorKit();
                if (ek instanceof HTMLEditorKit) {
                    StringBuffer buf = new StringBuffer(60);
                    buf.append("body { font: ");
                    buf.append(newFont.getSize()).append("pt ");
                    if (newFont.isBold()) {
                        buf.append("bold ");
                    }
                    if (newFont.isItalic()) {
                        buf.append("italic ");
                    }
                    buf.append('\"').append(newFont.getFamily()).append('\"');
                    buf.append(" }");
                    String cssData = buf.toString();
                    StyleSheet styleSheet = ((HTMLEditorKit)ek).getStyleSheet();
                    styleSheet.addRule(cssData);
                    styleSheet = ((HTMLDocument)this.html.getDocument()).getStyleSheet();
                    styleSheet.addRule(cssData);
                }
            } else if (changeName2.equals("clear")) {
                this.html.setText("");
            } else if (changeName2.equals("reload") && (url = this.html.getPage()) != null) {
                try {
                    this.html.setPage(url);
                }
                catch (IOException ek) {}
            }
        } else if (event.getSource() == this.html && (changeName = event.getPropertyName()).equals("page")) {
            BasicContentViewerUI.debug("page finished loading");
            this.loadingURL = false;
            if (this.pendingHighlightsEvent != null) {
                BasicContentViewerUI.debug("Loading the highlights now");
                this.highlightsChanged(this.pendingHighlightsEvent);
                this.pendingHighlightsEvent = null;
            }
            Document doc = this.html.getDocument();
            String title = (String)doc.getProperty("title");
            TextHelpModel model = this.theViewer.getModel();
            model.setDocumentTitle(title);
            this.theViewer.firePropertyChange(event.getPropertyName(), false, true);
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (e instanceof HTMLFrameHyperlinkEvent) {
                ((HTMLDocument)this.html.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
            } else {
                this.linkActivated(e.getURL());
            }
        }
    }

    protected void linkActivated(URL u) {
        String file;
        BasicContentViewerUI.debug("linkActivated - URL=" + u);
        Cursor c = this.html.getCursor();
        Cursor waitCursor = Cursor.getPredefinedCursor(3);
        this.html.setCursor(waitCursor);
        String ref = u.getRef();
        if (ref != null && ((file = u.getFile()).endsWith("/") || file.endsWith("\\"))) {
            u = this.html.getPage();
            BasicContentViewerUI.debug("current u=" + u);
            file = u.getFile();
            BasicContentViewerUI.debug("file=" + file);
            try {
                u = new URL(u.getProtocol(), u.getHost(), u.getPort(), file + "#" + ref);
            }
            catch (MalformedURLException e2) {
                return;
            }
            BasicContentViewerUI.debug("new u=" + u);
        }
        SwingUtilities.invokeLater(new PageLoader(u, c));
    }

    @Override
    public void highlightsChanged(TextHelpModelEvent e) {
        BasicContentViewerUI.debug("highlightsChanged " + e);
        if (this.loadingURL) {
            BasicContentViewerUI.debug("Humm. loadingURL wait a little");
            this.pendingHighlightsEvent = e;
            return;
        }
        Highlighter h = this.html.getHighlighter();
        BasicContentViewerUI.debug1("removeAllHighlights");
        h.removeAllHighlights();
        TextHelpModel m = (TextHelpModel)e.getSource();
        TextHelpModel.Highlight[] highlights = m.getHighlights();
        DefaultHighlighter.DefaultHighlightPainter p = new DefaultHighlighter.DefaultHighlightPainter(this.html.getSelectionColor());
        for (int i = 0; i < highlights.length; ++i) {
            int pos0 = highlights[i].getStartOffset();
            int pos1 = highlights[i].getEndOffset();
            BasicContentViewerUI.debug("  highlight: " + pos0 + ", " + pos1);
            try {
                h.addHighlight(pos0, pos1, p);
                if (i != 0) continue;
                ScrollToPosition callScrollToPosition = new ScrollToPosition(this.html, pos1);
                SwingUtilities.invokeLater(callScrollToPosition);
                continue;
            }
            catch (BadLocationException bl) {
                BasicContentViewerUI.debug("badLocationExcetpion thrown - " + bl);
            }
        }
        RepaintManager.currentManager(this.html).markCompletelyDirty(this.html);
    }

    private static void debug(String str) {
    }

    private static void debug1(String str) {
    }

    class JHEditorPane
    extends JEditorPane {
        private Hashtable typeHandlers;

        JHEditorPane() {
        }

        @Override
        public EditorKit getEditorKitForContentType(String type) {
            EditorKit k;
            if (this.typeHandlers == null) {
                this.typeHandlers = new Hashtable(3);
            }
            if ((k = (EditorKit)this.typeHandlers.get(type)) == null && (k = BasicContentViewerUI.this.theViewer.createEditorKitForContentType(type)) != null) {
                this.setEditorKitForContentType(type, k);
                this.typeHandlers.put(type, k);
            }
            if (k == null && (k = super.getEditorKitForContentType(type)) != null) {
                this.typeHandlers.put(type, k);
            }
            return k;
        }
    }

    class PageLoader
    implements Runnable {
        String title = null;
        URL url;
        Cursor cursor;

        PageLoader(URL u, Cursor c) {
            this.url = u;
            this.cursor = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.url == null) {
                BasicContentViewerUI.this.html.setCursor(this.cursor);
                RepaintManager.currentManager(BasicContentViewerUI.this.html).markCompletelyDirty(BasicContentViewerUI.this.html);
            } else {
                Document doc = BasicContentViewerUI.this.html.getDocument();
                try {
                    BasicContentViewerUI.this.html.setPage(this.url);
                    BasicContentViewerUI.this.loadingURL = true;
                    doc = BasicContentViewerUI.this.html.getDocument();
                    this.title = (String)doc.getProperty("title");
                    String anchor = this.url.getRef();
                    if (this.title == null) {
                        this.title = this.findTitle(this.url);
                    }
                    if (anchor != null) {
                        this.title = this.title + "-" + anchor;
                    }
                    TextHelpModel model = BasicContentViewerUI.this.theViewer.getModel();
                    model.setDocumentTitle(this.title);
                    Map.ID id = model.getHelpSet().getCombinedMap().getIDFromURL(this.url);
                    if (id != null) {
                        try {
                            model.setCurrentID(id, this.title, null);
                        }
                        catch (InvalidHelpSetContextException ex) {
                            model.setCurrentURL(this.url, this.title, null);
                        }
                    } else {
                        model.setCurrentURL(this.url, this.title, null);
                    }
                }
                catch (IOException ioe) {
                    BasicContentViewerUI.this.loadingURL = false;
                    BasicContentViewerUI.this.html.setDocument(doc);
                    BasicContentViewerUI.this.html.getToolkit().beep();
                }
                finally {
                    this.url = null;
                    SwingUtilities.invokeLater(this);
                }
            }
        }

        private String findTitle(URL url) {
            try {
                URLConnection conn = url.openConnection();
                InputStreamReader rd = new InputStreamReader(conn.getInputStream());
                ParserDelegator parser = new ParserDelegator();
                Callback callback = new Callback();
                parser.parse(rd, callback, true);
            }
            catch (Exception exp) {
                System.err.println(exp);
            }
            return this.title;
        }

        class Callback
        extends HTMLEditorKit.ParserCallback {
            boolean wasTitle = false;

            Callback() {
            }

            @Override
            public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (t.equals(HTML.Tag.TITLE)) {
                    this.wasTitle = true;
                }
            }

            @Override
            public void handleText(char[] data, int pos) {
                if (this.wasTitle) {
                    PageLoader.this.title = new String(data);
                    this.wasTitle = false;
                }
            }
        }
    }

    private class ScrollToPosition
    implements Runnable {
        private int pos;
        private JEditorPane html;

        public ScrollToPosition(JEditorPane html, int pos) {
            this.html = html;
            this.pos = pos;
        }

        @Override
        public void run() {
            try {
                Rectangle rec = this.html.modelToView(this.pos);
                if (rec != null) {
                    this.html.scrollRectToVisible(rec);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

