/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Locale;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleValue;
import javax.help.HelpUtilities;
import javax.help.Map;
import javax.help.SearchTOCItem;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class BasicSearchCellRenderer
extends JPanel
implements TreeCellRenderer {
    protected boolean selected;
    private boolean hasFocus;
    private boolean drawsFocusBorderAroundIcon;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;
    protected Map map;
    protected ValueJLabel hits;
    protected ValueJLabel quality;
    protected JLabel title;
    private static Icon high = UIManager.getIcon("SearchHigh.icon");
    private static Icon medhigh = UIManager.getIcon("SearchMedHigh.icon");
    private static Icon med = UIManager.getIcon("SearchMed.icon");
    private static Icon medlow = UIManager.getIcon("SearchMedLow.icon");
    private static Icon low = UIManager.getIcon("SearchLow.icon");
    private static boolean debug = false;

    public BasicSearchCellRenderer(Map map) {
        this.map = map;
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
        Object value = UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this.drawsFocusBorderAroundIcon = value != null && (Boolean)value != false;
        this.setLayout(new BoxLayout(this, 0));
        this.hits = new ValueJLabel();
        this.hits.setHorizontalAlignment(2);
        this.quality = new ValueJLabel();
        this.title = new JLabel();
        this.title.setFont(this.getFont());
        this.title.setHorizontalAlignment(2);
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add(this.quality);
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add(this.hits);
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add(this.title);
    }

    public void setTextSelectionColor(Color newColor) {
        this.textSelectionColor = newColor;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public void setTextNonSelectionColor(Color newColor) {
        this.textNonSelectionColor = newColor;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color newColor) {
        this.backgroundSelectionColor = newColor;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBackgroundNonSelectionColor(Color newColor) {
        this.backgroundNonSelectionColor = newColor;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public void setBorderSelectionColor(Color newColor) {
        this.borderSelectionColor = newColor;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    @Override
    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        if (font != null && this.title != null) {
            this.title.setFont(font);
        }
        super.setFont(font);
    }

    @Override
    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        SearchTOCItem item = (SearchTOCItem)((DefaultMutableTreeNode)value).getUserObject();
        String stringValue = "";
        if (item != null) {
            stringValue = item.getName();
        }
        if (sel) {
            this.hits.setForeground(this.getTextNonSelectionColor());
            this.title.setForeground(this.getTextSelectionColor());
            this.title.setBackground(this.getBackgroundSelectionColor());
        } else {
            Color bColor = this.getBackgroundNonSelectionColor();
            if (bColor == null) {
                bColor = this.getBackground();
            }
            this.hits.setForeground(this.getTextNonSelectionColor());
            this.title.setForeground(this.getTextNonSelectionColor());
            this.title.setBackground(bColor);
        }
        Locale locale = Locale.getDefault();
        if (item != null && (locale = item.getLocale()) != null) {
            this.setLocale(locale);
        }
        if (item != null) {
            int hitCount = item.hitCount();
            this.hits.setText(String.valueOf(hitCount));
            this.hits.setAccessibility(null, HelpUtilities.getString(locale, "search.hitDesc"), new Integer(hitCount), new Integer(hitCount), new Integer(hitCount));
            String qualityLevel = null;
            double penalty = item.getConfidence();
            if (penalty < 1.0) {
                this.quality.setIcon(high);
                qualityLevel = HelpUtilities.getString(locale, "search.high");
            } else if (penalty < 5.0) {
                this.quality.setIcon(medhigh);
                qualityLevel = HelpUtilities.getString(locale, "search.midhigh");
            } else if (penalty < 12.5) {
                this.quality.setIcon(med);
                qualityLevel = HelpUtilities.getString(locale, "search.mid");
            } else if (penalty < 25.0) {
                this.quality.setIcon(medlow);
                qualityLevel = HelpUtilities.getString(locale, "search.midlow");
            } else {
                this.quality.setIcon(low);
                qualityLevel = HelpUtilities.getString(locale, "search.low");
            }
            this.quality.setAccessibility(qualityLevel, HelpUtilities.getString(locale, "search.qualityDesc"), new Double(penalty), new Double(penalty), new Double(penalty));
            this.title.setText(stringValue);
        }
        this.selected = sel;
        this.hasFocus = hasFocus;
        return this;
    }

    @Override
    public void paint(Graphics g) {
        Color bColor;
        if (this.selected) {
            bColor = this.getBackgroundSelectionColor();
        } else {
            bColor = this.getBackgroundNonSelectionColor();
            if (bColor == null) {
                bColor = this.getBackground();
            }
        }
        int imageOffset = -1;
        if (bColor != null) {
            imageOffset = this.getLabelStart();
            g.setColor(bColor);
            Dimension size = this.getSize();
            g.fillRect(imageOffset, 0, size.width - 1 - imageOffset, size.height);
        }
        if (this.hasFocus) {
            if (this.drawsFocusBorderAroundIcon) {
                imageOffset = 0;
            } else if (imageOffset == -1) {
                imageOffset = this.getLabelStart();
            }
            g.setColor(this.getBorderSelectionColor());
            g.drawRect(imageOffset, 0, this.getWidth() - 1 - imageOffset, this.getHeight() - 1);
        }
        super.paintChildren(g);
    }

    private int getLabelStart() {
        return this.title.getX() - 1;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension retDimension = super.getPreferredSize();
        int width = 0;
        int height = 0;
        if (retDimension != null) {
            height = retDimension.height;
        }
        Insets insets = this.getInsets();
        width += insets.left + insets.right;
        width += 4;
        Dimension size = this.quality.getPreferredSize();
        width += size.width;
        height = Math.max(height, size.height + insets.top + insets.bottom);
        width += 4;
        size = this.hits.getPreferredSize();
        width += size.width;
        height = Math.max(height, size.height + insets.top + insets.bottom);
        width += 4;
        size = this.title.getPreferredSize();
        width += size.width;
        height = Math.max(height, size.height + insets.top + insets.bottom);
        width += 3;
        if (retDimension != null) {
            retDimension = new Dimension(retDimension.width + 3, retDimension.height);
        }
        retDimension.setSize(width, height);
        return retDimension;
    }

    private static void debug(String str) {
        if (debug) {
            System.out.println("BasicSearchCellRenderer: " + str);
        }
    }

    private class ValueJLabel
    extends JLabel {
        String accessName;
        String accessDesc;
        Number accessValue;
        Number minValue;
        Number maxValue;

        private ValueJLabel() {
        }

        public void setAccessibility(String accessName, String accessDesc, Number accessValue, Number minValue, Number maxValue) {
            this.accessName = accessName;
            this.accessDesc = accessDesc;
            this.accessValue = accessValue;
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleValueJLabel();
            }
            this.accessibleContext.setAccessibleDescription(this.accessDesc);
            this.accessibleContext.setAccessibleName(this.accessName);
            return this.accessibleContext;
        }

        protected class AccessibleValueJLabel
        extends JLabel.AccessibleJLabel
        implements AccessibleValue {
            protected AccessibleValueJLabel() {
                super(ValueJLabel.this);
            }

            @Override
            public AccessibleValue getAccessibleValue() {
                return this;
            }

            @Override
            public Number getCurrentAccessibleValue() {
                return ValueJLabel.this.accessValue;
            }

            @Override
            public boolean setCurrentAccessibleValue(Number n) {
                return false;
            }

            @Override
            public Number getMinimumAccessibleValue() {
                return ValueJLabel.this.minValue;
            }

            @Override
            public Number getMaximumAccessibleValue() {
                return ValueJLabel.this.maxValue;
            }
        }
    }
}

