/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import com.sun.java.help.impl.SwingWorker;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.help.BadIDException;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpNavigator;
import javax.help.JHelpTOCNavigator;
import javax.help.Map;
import javax.help.Merge;
import javax.help.MergeHelpUtilities;
import javax.help.NavigatorView;
import javax.help.Popup;
import javax.help.Presentation;
import javax.help.TOCItem;
import javax.help.TOCView;
import javax.help.TreeItem;
import javax.help.WindowPresentation;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.plaf.HelpNavigatorUI;
import javax.help.plaf.basic.BasicTOCCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.RepaintManager;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class BasicTOCNavigatorUI
extends HelpNavigatorUI
implements HelpModelListener,
TreeSelectionListener,
PropertyChangeListener,
ComponentListener,
Serializable {
    protected JHelpTOCNavigator toc;
    protected JScrollPane sp;
    protected DefaultMutableTreeNode topNode;
    protected JTree tree;
    private boolean inInstallUI = false;
    private SwingWorker worker = null;
    protected static final boolean debug = false;

    public static ComponentUI createUI(JComponent x) {
        return new BasicTOCNavigatorUI((JHelpTOCNavigator)x);
    }

    public BasicTOCNavigatorUI(JHelpTOCNavigator b) {
        BasicTOCNavigatorUI.debug(this + " CreateUI - sort of");
        ImageIcon icon = this.getImageIcon(b.getNavigatorView());
        if (icon != null) {
            this.setIcon(icon);
        } else {
            this.setIcon(UIManager.getIcon("TOCNav.icon"));
        }
    }

    @Override
    public void installUI(JComponent c) {
        BasicTOCNavigatorUI.debug(this + " installUI");
        this.inInstallUI = true;
        this.toc = (JHelpTOCNavigator)c;
        HelpModel model = this.toc.getModel();
        this.toc.setLayout(new BorderLayout());
        this.toc.addPropertyChangeListener(this);
        this.toc.addComponentListener(this);
        if (model != null) {
            model.addHelpModelListener(this);
        }
        this.topNode = new DefaultMutableTreeNode();
        this.tree = new JTree(this.topNode);
        TreeSelectionModel tsm = this.tree.getSelectionModel();
        tsm.addTreeSelectionListener(this);
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.setCellRenderer(this.toc.getNavigatorView(), this.tree);
        this.sp = new JScrollPane();
        this.sp.getViewport().add(this.tree);
        this.toc.add("Center", this.sp);
        this.reloadData();
        this.inInstallUI = false;
    }

    protected void setCellRenderer(NavigatorView view, JTree tree) {
        Map map = view.getHelpSet().getCombinedMap();
        tree.setCellRenderer(new BasicTOCCellRenderer(map, (TOCView)view));
    }

    @Override
    public void uninstallUI(JComponent c) {
        BasicTOCNavigatorUI.debug(this + " unistallUI");
        HelpModel model = this.toc.getModel();
        this.toc.removeComponentListener(this);
        this.toc.removePropertyChangeListener(this);
        TreeSelectionModel tsm = this.tree.getSelectionModel();
        tsm.removeTreeSelectionListener(this);
        this.toc.setLayout(null);
        this.toc.removeAll();
        if (model != null) {
            model.removeHelpModelListener(this);
        }
        this.toc = null;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(200, 100);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(100, 100);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    private void reloadData() {
        BasicTOCNavigatorUI.debug("reloadData");
        TOCView view = (TOCView)this.toc.getNavigatorView();
        if (this.worker != null) {
            this.worker.interrupt();
        }
        this.worker = new NavSwingWorker(view);
        this.worker.start(1);
    }

    private synchronized Object loadData(TOCView view) {
        if (view == null) {
            return Boolean.FALSE;
        }
        this.topNode.removeAllChildren();
        String mergeType = view.getMergeType();
        Locale locale = view.getHelpSet().getLocale();
        DefaultMutableTreeNode node = view.getDataAsTree();
        MergeHelpUtilities.mergeNodeChildren(mergeType, node);
        while (node.getChildCount() > 0) {
            this.topNode.add((DefaultMutableTreeNode)node.getFirstChild());
        }
        this.addSubHelpSets(view.getHelpSet());
        return Boolean.TRUE;
    }

    private void presentData() {
        Map.ID id;
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
        if (this.toc.getModel() != null && (id = this.toc.getModel().getCurrentID()) != null) {
            DefaultMutableTreeNode selectedNode = this.findID(this.topNode, id);
            this.selectNode(selectedNode);
        }
    }

    private void reloadData(HelpModel model) {
        BasicTOCNavigatorUI.debug("reloadData using new model");
        TOCView view = null;
        HelpSet newHelpSet = model.getHelpSet();
        TOCView oldView = (TOCView)this.toc.getNavigatorView();
        String oldName = oldView.getName();
        NavigatorView[] navViews = newHelpSet.getNavigatorViews();
        for (int i = 0; i < navViews.length; ++i) {
            NavigatorView tempView;
            if (!navViews[i].getName().equals(oldName) || !((tempView = navViews[i]) instanceof TOCView)) continue;
            view = (TOCView)tempView;
            break;
        }
        if (this.worker != null) {
            this.worker.interrupt();
        }
        this.worker = new NavSwingWorker(view);
        this.worker.start(1);
    }

    protected void addSubHelpSets(HelpSet hs) {
        BasicTOCNavigatorUI.debug("addSubHelpSets");
        Enumeration e = hs.getHelpSets();
        while (e.hasMoreElements()) {
            HelpSet ehs = (HelpSet)e.nextElement();
            NavigatorView[] views = ehs.getNavigatorViews();
            for (int i = 0; i < views.length; ++i) {
                if (!this.toc.canMerge(views[i])) continue;
                this.doMerge(views[i]);
            }
            this.addSubHelpSets(ehs);
        }
    }

    private void expand(String target) {
        BasicTOCNavigatorUI.debug("expand called");
        Enumeration nodes = this.findNodes(target).elements();
        DefaultMutableTreeNode node = null;
        while (nodes.hasMoreElements()) {
            TreePath path;
            node = (DefaultMutableTreeNode)nodes.nextElement();
            BasicTOCNavigatorUI.debug("expandPath :" + node);
            if (node.getChildCount() > 0) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getFirstChild();
                path = new TreePath(child.getPath());
                this.tree.makeVisible(path);
                continue;
            }
            Object[] treeNode = node.getPath();
            path = new TreePath(treeNode);
            this.tree.makeVisible(path);
        }
    }

    private Vector findNodes(String target) {
        Enumeration<TreeNode> nodes = this.topNode.preorderEnumeration();
        DefaultMutableTreeNode node = null;
        Vector<DefaultMutableTreeNode> nodeFound = new Vector<DefaultMutableTreeNode>();
        while (nodes.hasMoreElements()) {
            node = (DefaultMutableTreeNode)nodes.nextElement();
            BasicTOCNavigatorUI.debug(" node :" + node.toString());
            if (node == null) continue;
            TOCItem tocItem = (TOCItem)node.getUserObject();
            if (tocItem == null) {
                BasicTOCNavigatorUI.debug("tocItem is null");
                continue;
            }
            Map.ID id = tocItem.getID();
            if (id == null) continue;
            BasicTOCNavigatorUI.debug("id name :" + id.id);
            BasicTOCNavigatorUI.debug("target :" + target);
            Map.ID itemID = null;
            try {
                itemID = Map.ID.create(target, this.toc.getModel().getHelpSet());
            }
            catch (BadIDException exp) {
                System.err.println("Not valid ID :" + target);
                break;
            }
            if (!id.equals(itemID)) continue;
            nodeFound.addElement(node);
        }
        return nodeFound;
    }

    private void collapse(String target) {
        Enumeration nodes = this.findNodes(target).elements();
        DefaultMutableTreeNode node = null;
        BasicTOCNavigatorUI.debug("collapse called");
        while (nodes.hasMoreElements()) {
            TreePath path;
            node = (DefaultMutableTreeNode)nodes.nextElement();
            if (node.getChildCount() > 0) {
                Object[] treeNode = node.getPath();
                path = new TreePath(treeNode);
                this.tree.collapsePath(path);
                this.tree.collapseRow(this.tree.getRowForPath(path));
                continue;
            }
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            path = new TreePath(parent.getPath());
            this.tree.collapseRow(this.tree.getRowForPath(path));
        }
    }

    public void doMerge(NavigatorView view) {
        BasicTOCNavigatorUI.debug("merging data");
        Merge mergeObject = Merge.DefaultMergeFactory.getMerge(this.toc.getNavigatorView(), view);
        if (mergeObject != null) {
            mergeObject.processMerge(this.topNode);
        }
    }

    @Override
    public void merge(NavigatorView view) {
        BasicTOCNavigatorUI.debug("merging " + view);
        this.doMerge(view);
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
    }

    @Override
    public void remove(NavigatorView view) {
        BasicTOCNavigatorUI.debug("removing " + view);
        this.remove(this.topNode, view.getHelpSet());
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
    }

    private void remove(DefaultMutableTreeNode node, HelpSet hs) {
        BasicTOCNavigatorUI.debug("remove(" + node + ", " + hs + ")");
        Vector<DefaultMutableTreeNode> toRemove = new Vector<DefaultMutableTreeNode>();
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
            BasicTOCNavigatorUI.debug("  considering " + child);
            TOCItem item = (TOCItem)child.getUserObject();
            HelpSet chs = item.getHelpSet();
            BasicTOCNavigatorUI.debug("chs=" + chs + " hs.contains(chs)=" + hs.contains(chs));
            if (chs != null && hs.contains(chs)) {
                if (child.isLeaf()) {
                    BasicTOCNavigatorUI.debug("  tagging for removal: " + child);
                    toRemove.addElement(child);
                    continue;
                }
                this.remove(child, hs);
                if (child.isLeaf()) {
                    BasicTOCNavigatorUI.debug("  tagging for removal: " + child);
                    toRemove.addElement(child);
                    continue;
                }
                DefaultMutableTreeNode childOne = (DefaultMutableTreeNode)child.getFirstChild();
                TOCItem itemOne = (TOCItem)childOne.getUserObject();
                item.setHelpSet(itemOne.getHelpSet());
                BasicTOCNavigatorUI.debug("  orphaned children - changing hs: " + child);
                continue;
            }
            this.remove(child, hs);
        }
        for (int i = 0; i < toRemove.size(); ++i) {
            BasicTOCNavigatorUI.debug("  removing " + toRemove.elementAt(i));
            node.remove((DefaultMutableTreeNode)toRemove.elementAt(i));
        }
    }

    private void setVisibility(DefaultMutableTreeNode node) {
        TOCItem item = (TOCItem)node.getUserObject();
        int expandType = -1;
        if (item != null) {
            expandType = item.getExpansionType();
        }
        TreePath path = new TreePath(node.getPath());
        int pathcount = path.getPathCount();
        if (node == this.topNode || pathcount <= 2 && expandType == -1 || expandType == 1) {
            this.tree.expandPath(new TreePath(node.getPath()));
            if (!node.isLeaf()) {
                int max = node.getChildCount();
                for (int i = 0; i < max; ++i) {
                    this.setVisibility((DefaultMutableTreeNode)node.getChildAt(i));
                }
            }
        }
    }

    @Override
    public synchronized void idChanged(HelpModelEvent e) {
        Map.ID nId;
        DefaultMutableTreeNode tn;
        TOCItem item;
        Object o;
        TreePath s;
        Map.ID id = e.getID();
        HelpModel helpModel = this.toc.getModel();
        BasicTOCNavigatorUI.debug("idChanged(" + e + ")");
        if (e.getSource() != helpModel) {
            BasicTOCNavigatorUI.debug("Internal inconsistency!");
            BasicTOCNavigatorUI.debug("  " + e.getSource() + " != " + helpModel);
            throw new Error("Internal error");
        }
        if (id == null) {
            id = helpModel.getHelpSet().getCombinedMap().getClosestID(e.getURL());
        }
        if ((s = this.tree.getSelectionPath()) != null && (o = s.getLastPathComponent()) instanceof DefaultMutableTreeNode && (item = (TOCItem)(tn = (DefaultMutableTreeNode)o).getUserObject()) != null && (nId = item.getID()) != null && nId.equals(id)) {
            return;
        }
        DefaultMutableTreeNode node = this.findID(this.topNode, id);
        this.selectNode(node);
    }

    private DefaultMutableTreeNode findID(DefaultMutableTreeNode node, Map.ID id) {
        BasicTOCNavigatorUI.debug("findID: (" + id + ")");
        BasicTOCNavigatorUI.debug("  node: " + node);
        if (id == null) {
            return null;
        }
        TOCItem item = (TOCItem)node.getUserObject();
        if (item != null) {
            Map.ID testID = item.getID();
            BasicTOCNavigatorUI.debug("  testID: " + testID);
            if (testID != null && testID.equals(id)) {
                return node;
            }
        }
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            DefaultMutableTreeNode tmp = (DefaultMutableTreeNode)node.getChildAt(i);
            DefaultMutableTreeNode test = this.findID(tmp, id);
            if (test == null) continue;
            return test;
        }
        return null;
    }

    private void selectNode(DefaultMutableTreeNode node) {
        if (node == null) {
            this.tree.clearSelection();
            return;
        }
        TreePath path = new TreePath(node.getPath());
        this.tree.expandPath(path);
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
    }

    protected JHelpNavigator getHelpNavigator() {
        return this.toc;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TOCItem item;
        JHelpNavigator navigator = this.getHelpNavigator();
        HelpModel helpmodel = navigator.getModel();
        BasicTOCNavigatorUI.debug("ValueChanged: " + e);
        BasicTOCNavigatorUI.debug("  model: " + helpmodel);
        TreeItem[] items = null;
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths != null) {
            items = new TreeItem[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                if (paths[i] == null) continue;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                items[i] = (TreeItem)node.getUserObject();
            }
        }
        navigator.setSelectedItems(items);
        if (items != null && items.length == 1 && (item = (TOCItem)items[0]) != null && item.getID() != null) {
            Presentation pres;
            String presentation = item.getPresentation();
            if (presentation == null) {
                try {
                    helpmodel.setCurrentID(item.getID(), item.getName(), navigator);
                }
                catch (InvalidHelpSetContextException ex) {
                    System.err.println("BadID: " + item.getID());
                    return;
                }
            }
            if (this.inInstallUI) {
                this.tree.clearSelection();
                return;
            }
            HelpSet hs = helpmodel.getHelpSet();
            Class[] types = new Class[]{HelpSet.class, String.class};
            Object[] args = new Object[]{hs, item.getPresentationName()};
            try {
                ClassLoader loader = hs.getLoader();
                Class<?> klass = loader == null ? Class.forName(presentation) : loader.loadClass(presentation);
                Method m = klass.getMethod("getPresentation", types);
                pres = (Presentation)m.invoke(null, args);
            }
            catch (Exception ex) {
                throw new RuntimeException("error invoking presentation");
            }
            if (pres == null) {
                return;
            }
            if (pres instanceof WindowPresentation) {
                ((WindowPresentation)pres).setActivationObject(this.tree);
            }
            if (pres instanceof Popup) {
                ((Popup)pres).setInvokerInternalBounds(this.tree.getPathBounds(paths[0]));
                ((Popup)pres).setInvoker(this.tree);
            }
            try {
                pres.setCurrentID(item.getID());
            }
            catch (InvalidHelpSetContextException ex) {
                System.err.println("BadID: " + item.getID());
                return;
            }
            pres.setDisplayed(true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        BasicTOCNavigatorUI.debug(this + " propertyChange: " + event.getSource() + " " + event.getPropertyName());
        if (event.getSource() == this.toc) {
            String changeName = event.getPropertyName();
            if (changeName.equals("helpModel")) {
                this.reloadData((HelpModel)event.getNewValue());
            } else if (changeName.equals("font")) {
                BasicTOCNavigatorUI.debug("Font change");
                Font newFont = (Font)event.getNewValue();
                this.tree.setFont(newFont);
                RepaintManager.currentManager(this.tree).markCompletelyDirty(this.tree);
            } else if (changeName.equals("expand")) {
                BasicTOCNavigatorUI.debug("Expand change");
                this.expand((String)event.getNewValue());
            } else if (changeName.equals("collapse")) {
                BasicTOCNavigatorUI.debug("Collapse change");
                this.collapse((String)event.getNewValue());
            }
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.tree.requestFocus();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    protected static void debug(String str) {
    }

    private class NavSwingWorker
    extends SwingWorker {
        TOCView view;

        public NavSwingWorker(TOCView view) {
            this.view = view;
        }

        @Override
        public Object construct() {
            return BasicTOCNavigatorUI.this.loadData(this.view);
        }

        @Override
        public void finished() {
            if ((Boolean)this.get() == Boolean.TRUE) {
                BasicTOCNavigatorUI.this.presentData();
            }
        }
    }
}

