/*
 * Decompiled with CFR 0.152.
 */
package javax.help.search;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class ConfigFile {
    private String remove;
    private String prepend;
    private String stopWordFileName;
    private Hashtable stopWords;
    private String[] defStopWords = new String[]{"a", "all", "am", "an", "and", "any", "are", "as", "at", "be", "but", "by", "can", "could", "did", "do", "does", "etc", "for", "from", "goes", "got", "had", "has", "have", "he", "her", "him", "his", "how", "if", "in", "is", "it", "let", "me", "more", "much", "must", "my", "nor", "not", "now", "of", "off", "on", "or", "our", "own", "see", "set", "shall", "she", "should", "so", "some", "than", "that", "the", "them", "then", "there", "these", "this", "those", "though", "to", "too", "us", "was", "way", "we", "what", "when", "where", "which", "who", "why", "will", "would", "yes", "yet", "you"};
    private ArrayList files;

    public ConfigFile(String configFile, ArrayList files, boolean noStopWords) {
        this.files = files;
        String removeText = new String("IndexRemove ");
        String prependText = new String("IndexPrepend ");
        String fileText = new String("File ");
        String stopWordsText = new String("StopWords ");
        String stopWordsFileText = new String("StopWordsFile ");
        this.stopWords = new Hashtable();
        if (configFile == null) {
            if (!noStopWords) {
                this.useDefaultStopWords();
            }
            return;
        }
        try {
            String line;
            LineNumberReader in = new LineNumberReader(new BufferedReader(new FileReader(configFile)));
            while ((line = in.readLine()) != null) {
                if (line.startsWith(removeText)) {
                    this.remove = line.substring(removeText.length(), line.length());
                    this.remove = this.AdapaptFileSeparator(this.remove);
                    continue;
                }
                if (line.startsWith(prependText)) {
                    this.prepend = line.substring(prependText.length(), line.length());
                    this.prepend = this.AdapaptFileSeparator(this.prepend);
                    continue;
                }
                if (line.startsWith(fileText)) {
                    String file = line.substring(fileText.length(), line.length());
                    files.add(file);
                    continue;
                }
                if (line.startsWith(stopWordsFileText)) {
                    this.stopWordFileName = line.substring(stopWordsFileText.length(), line.length());
                    this.addStopWordsFile(this.stopWordFileName);
                    continue;
                }
                if (line.startsWith(stopWordsText)) {
                    if (noStopWords) continue;
                    String words = line.substring(stopWordsText.length(), line.length());
                    BreakIterator boundary = BreakIterator.getWordInstance();
                    boundary.setText(words);
                    int start = boundary.first();
                    int end = boundary.next();
                    while (end != -1) {
                        String word = words.substring(start, end).trim().toLowerCase();
                        if (!word.equals(",") && !word.equals("")) {
                            this.stopWords.put(word, word);
                        }
                        start = end;
                        end = boundary.next();
                    }
                    continue;
                }
                System.out.println("Unknown Config Keyword at line " + in.getLineNumber());
            }
            if (this.stopWords.isEmpty() && !noStopWords) {
                this.useDefaultStopWords();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String AdapaptFileSeparator(String PathFileName) {
        if (File.separator == "/") {
            return PathFileName.replace("/", File.separator);
        }
        return PathFileName.replace("\\", File.separator);
    }

    public void SetStopTxtFile(String value) {
        if (this.stopWordFileName == null) {
            this.stopWordFileName = value;
            this.addStopWordsFile(this.stopWordFileName);
        }
    }

    public void SetRemove(String value) {
        if (this.remove == null) {
            this.remove = value.replace("/", File.separator);
        }
    }

    public String getURLString(String file) {
        Object url = this.remove != null && file.startsWith(this.remove) ? file.substring(this.remove.length(), file.length()) : file;
        if (this.prepend != null) {
            url = this.prepend + (String)url;
        }
        if (File.separatorChar != '/') {
            url = ((String)url).replace(File.separatorChar, '/');
        }
        return url;
    }

    public Enumeration getStopWords() {
        return this.stopWords.elements();
    }

    public ArrayList getFiles() {
        return this.files;
    }

    private void useDefaultStopWords() {
        for (int i = 0; i < this.defStopWords.length; ++i) {
            this.stopWords.put(this.defStopWords[i], this.defStopWords[i]);
        }
    }

    private void addStopWordsFile(String swfile) {
        if (swfile == null) {
            return;
        }
        try {
            String word;
            LineNumberReader in = new LineNumberReader(new BufferedReader(new FileReader(swfile)));
            while ((word = in.readLine()) != null) {
                word = word.trim();
                this.stopWords.put(word, word);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

